/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.helpers;

import app.valuationcontrol.multimodule.library.entities.Model;
import java.util.Objects;

public record DataPeriod(Model myModel, Integer periodOffset, Integer segmentOffsetFactor, boolean isConstant, Integer[] triangleOffset) {
    public Integer getTotalOffsetAsInteger() {
        return Objects.requireNonNullElse(this.periodOffset, 0) + this.segmentOffsetFactor * this.myModel.getNumberOfPeriodsAndValue();
    }

    public Integer getColumn() {
        if (this.isConstant) {
            return this.myModel.getConstantColumn() + this.getSegmentOffsetAsInteger();
        }
        return this.myModel.getConstantColumn() + this.myModel.getNbHistoricalPeriod() + 1 + this.getTotalOffsetAsInteger();
    }

    public Integer getSegmentOffsetAsInteger() {
        return this.segmentOffsetFactor * this.myModel.getNumberOfPeriodsAndValue();
    }

    public Integer lowBound() {
        return -this.myModel.getNbHistoricalPeriod().intValue();
    }

    public Integer highBound() {
        return this.myModel.getNbProjectionPeriod() - 1;
    }

    public boolean isWithinBound(Integer periodToCheck) {
        return periodToCheck >= this.lowBound() && periodToCheck <= this.highBound();
    }

    public DataPeriod previousPeriod() {
        return new DataPeriod(this.myModel, this.periodOffset - 1, this.segmentOffsetFactor, this.isConstant, this.triangleOffset);
    }
}

