/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.helpers.openai;

import app.valuationcontrol.multimodule.library.helpers.exceptions.ResourceException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class OpenAiServiceImplementation {
    @Generated
    private static final Logger log = LogManager.getLogger(OpenAiServiceImplementation.class);
    private final ChatClient chatClient;

    @Autowired
    public OpenAiServiceImplementation(ChatClient.Builder chatClientBuilder) {
        this.chatClient = chatClientBuilder.build();
    }

    public ChatClient.CallResponseSpec getChatRequest(Prompt prompt, Object toolObject) {
        if (toolObject != null) {
            return this.chatClient.prompt(prompt).tools(new Object[]{toolObject}).call();
        }
        return this.chatClient.prompt(prompt).call();
    }

    public JsonNode doRequest(Prompt messages, Object tool) {
        try {
            ChatClient.CallResponseSpec chatCompletionRequest = this.getChatRequest(messages, tool);
            ObjectMapper objectMapper = new ObjectMapper();
            String chatResponse = chatCompletionRequest.content();
            if (chatResponse != null && !chatResponse.isEmpty()) {
                if (tool != null) {
                    return objectMapper.readTree(chatResponse);
                }
                ObjectNode _rootNode = objectMapper.createObjectNode();
                _rootNode.put("response", chatResponse);
                return _rootNode;
            }
            throw new ResourceException(HttpStatus.BAD_REQUEST, "Couldn't parse empty response OpenAI");
        }
        catch (Exception e) {
            log.debug((Object)e);
            throw new ResourceException(HttpStatus.GATEWAY_TIMEOUT, "the OPen AI server did not respond");
        }
    }

    @Generated
    public ChatClient getChatClient() {
        return this.chatClient;
    }
}

