/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.records.JSONRecords;

import app.valuationcontrol.multimodule.library.entities.Area;
import app.valuationcontrol.multimodule.library.entities.Model;
import app.valuationcontrol.multimodule.library.entities.Segment;
import app.valuationcontrol.multimodule.library.entities.SubArea;
import app.valuationcontrol.multimodule.library.entities.Variable;
import app.valuationcontrol.multimodule.library.entities.VariableValue;
import app.valuationcontrol.multimodule.library.helpers.exceptions.ResourceException;
import app.valuationcontrol.multimodule.library.records.JSONRecords.JSONArea;
import app.valuationcontrol.multimodule.library.records.JSONRecords.JSONSegment;
import app.valuationcontrol.multimodule.library.records.JSONRecords.JSONSubArea;
import app.valuationcontrol.multimodule.library.records.JSONRecords.JSONVariable;
import app.valuationcontrol.multimodule.library.records.JSONRecords.JSONVariableValue;
import app.valuationcontrol.multimodule.library.records.ModelData;
import app.valuationcontrol.multimodule.library.records.SegmentData;
import java.util.Calendar;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;

public record JSONModelRecord(String name, int nbHistoricalPeriod, int nbForecastPeriod, int startYear, JSONArea[] areas, JSONVariable[] variables, JSONVariableValue[] variableValues, JSONSegment[] segments) {
    @Generated
    private static final Logger log = LogManager.getLogger(JSONModelRecord.class);

    public Model getModel() {
        int nbHistoricalPeriod;
        int nbForecastPeriod;
        int startYear;
        String modelName = this.name();
        try {
            startYear = this.startYear();
        }
        catch (Exception e) {
            startYear = 0;
        }
        if (startYear == 0) {
            startYear = Calendar.getInstance().get(1);
        }
        try {
            nbForecastPeriod = this.nbForecastPeriod();
        }
        catch (Exception e) {
            nbForecastPeriod = 5;
        }
        try {
            nbHistoricalPeriod = this.nbHistoricalPeriod();
        }
        catch (Exception e) {
            nbHistoricalPeriod = 3;
        }
        modelName = modelName != null ? modelName : "Default model";
        ModelData modelData = new ModelData(-1L, modelName, startYear, nbHistoricalPeriod, nbForecastPeriod, "Company Number", "Company ID", "CU", "", false, false, null);
        Model model = new Model(modelData);
        int areaOrder = 0;
        for (JSONArea areaObject : this.areas()) {
            Area area2 = new Area(model, areaObject.name(), "", areaOrder);
            int subAreaOrder = 0;
            for (JSONSubArea jsonSubArea : areaObject.subAreas()) {
                SubArea subArea = new SubArea();
                subArea.setAttachedArea(area2);
                subArea.setSubAreaName(jsonSubArea.name());
                subArea.setSubAreaDescription(jsonSubArea.description());
                subArea.setModelledAtSegment(jsonSubArea.modelledAtSegment());
                subArea.setSubAreaOrder(subAreaOrder);
                area2.getSubAreas().add(subArea);
                ++subAreaOrder;
            }
            ++areaOrder;
            model.getAreas().add(area2);
        }
        int variableOrder = 0;
        for (JSONVariable jSONVariable : this.variables()) {
            SubArea subArea;
            Variable variable = new Variable();
            variable.setAttachedModel(model);
            variable.setVariableName(jSONVariable.name());
            variable.setVariableFormula(jSONVariable.formula() != null && !jSONVariable.formula().isBlank() ? jSONVariable.formula() : "0");
            String variableType = switch (jSONVariable.variableType()) {
                case "Input" -> "input";
                case "Total" -> "total_row";
                case "Check" -> "check";
                case "Constant" -> "constant";
                case "Single Result" -> "single_result";
                default -> "calc";
            };
            variable.setVariableType(variableType);
            variable.setVariableDescription(jSONVariable.description());
            try {
                subArea = (SubArea)model.getAreas().stream().flatMap(area -> area.getSubAreas().stream().filter(subArea1 -> subArea1.getSubAreaName().equals(jsonVariable.subArea()))).findFirst().orElseThrow();
            }
            catch (Exception e) {
                log.info("Couldn't FIND SUBAREA,{}", (Object)jSONVariable.subArea());
                throw new RuntimeException(e);
            }
            variable.setVariableSubArea(subArea);
            variable.setVariableArea(subArea.getAttachedArea());
            variable.setVariableOrder(variableOrder);
            if (jSONVariable.name().contains("percent")) {
                variable.setVariableFormat("percent");
            } else if (jSONVariable.name().contains("total")) {
                variable.setVariableFormat("total");
            } else {
                variable.setVariableFormat("decimal");
            }
            ++variableOrder;
            log.info("Variable {}, Area {}, Subarea {}", (Object)variable.getVariableName(), (Object)subArea.getAttachedArea().getAreaName(), (Object)subArea.getSubAreaName());
            model.getVariables().add(variable);
        }
        log.debug("All variables loaded");
        if (this.segments != null) {
            for (Record record : this.segments) {
                SegmentData segmentData = new SegmentData(-1L, ((JSONSegment)record).name(), ((JSONSegment)record).currency());
                Segment segment = new Segment(segmentData, model);
                model.getSegments().add(segment);
            }
        }
        if (this.variableValues != null) {
            for (Record record : this.variableValues) {
                Variable variable = model.getVariables().stream().filter(arg_0 -> JSONModelRecord.lambda$getModel$2((JSONVariableValue)record, arg_0)).findFirst().orElseThrow(() -> new ResourceException(HttpStatus.BAD_REQUEST, "Couldnt find a matching variable for {}"));
                VariableValue variableValue = new VariableValue();
                variableValue.setAttachedVariable(variable);
                variableValue.setValue(((JSONVariableValue)record).value());
                variableValue.setScenarioNumber(((JSONVariableValue)record).scenario());
                variableValue.setPeriod(((JSONVariableValue)record).period());
                variableValue.setAttachedSegment(null);
                variableValue.setEditor("");
                variableValue.setSourceFile("Json Import");
                variable.getVariableValues().add(variableValue);
            }
        }
        return model;
    }

    private static /* synthetic */ boolean lambda$getModel$2(JSONVariableValue jsonVariableValue, Variable v) {
        return v.getVariableName().equalsIgnoreCase(jsonVariableValue.variableName());
    }
}

