/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.xlhandler;

import app.valuationcontrol.multimodule.library.entities.Model;
import app.valuationcontrol.multimodule.library.entities.Sensitivity;
import app.valuationcontrol.multimodule.library.entities.SensitivityResult;
import app.valuationcontrol.multimodule.library.entities.Variable;
import app.valuationcontrol.multimodule.library.xlhandler.CalcDocument;
import app.valuationcontrol.multimodule.library.xlhandler.GenericSheet;
import app.valuationcontrol.multimodule.library.xlhandler.POICalcDocument;
import app.valuationcontrol.multimodule.library.xlhandler.SCENARIO;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record SensitivityRunner(CalcDocument calcDocument, List<Sensitivity> sensitivities, SCENARIO scenario, Model model) {
    @Generated
    private static final Logger log = LogManager.getLogger(SensitivityRunner.class);
    static final String SENSITIVITY_SHEET = POICalcDocument.getScenarioSheetName(SCENARIO.SENSITIVITY);

    public List<SensitivityResult> runSensitivities() {
        ArrayList<SensitivityResult> sensitivityResults = new ArrayList<SensitivityResult>();
        for (Sensitivity sensitivity : this.sensitivities) {
            log.info("Running sentivity " + sensitivity.getSensitivityName() + "for scenario  " + String.valueOf((Object)this.scenario));
            Optional<Variable> variable1 = this.model.getVariableWithID(sensitivity.getSensitivityVariable1Id());
            Optional<Variable> variable2 = this.model.getVariableWithID(sensitivity.getSensitivityVariable2Id());
            Optional<Variable> measurementVariable = this.model.getVariableWithID(sensitivity.getSensitivityMeasurementVariableId());
            if (variable1.isEmpty() || variable2.isEmpty() || measurementVariable.isEmpty()) {
                throw new IllegalArgumentException("One of the variables is not set");
            }
            double[] originalVariable1Value = new double[variable1.get().isModelledAtSegment() ? Math.max(1, this.model.getSegments().size()) : 1];
            double[] originalVariable2Value = new double[variable2.get().isModelledAtSegment() ? Math.max(1, this.model.getSegments().size()) : 1];
            double[] originalMeasurementValue = new double[measurementVariable.get().isModelledAtSegment() ? Math.max(1, this.model.getSegments().size() + 1) : 1];
            int column = 0;
            try {
                int k;
                GenericSheet scenarioGenericSheet = this.calcDocument.getSheet(this.scenario);
                GenericSheet sensitivityGenericSheet = this.calcDocument.copy(scenarioGenericSheet, SENSITIVITY_SHEET);
                int numberOfMeasurementSegments = measurementVariable.get().isModelledAtSegment() ? Math.max(1, this.model.getSegments().size() + 1) : 1;
                SensitivityResult sensitivityResult = new SensitivityResult(sensitivity.getId(), this.scenario.ordinal(), sensitivity.getSensitivityVariable1Steps(), sensitivity.getSensitivityVariable2Steps(), numberOfMeasurementSegments);
                if (variable1.get().isModelledAtSegment() && !this.model.getSegments().isEmpty()) {
                    for (k = 0; k < this.model.getSegments().size(); ++k) {
                        originalVariable1Value[k] = this.getValueForVariableAtPeriod(variable1.get(), variable1.get().columnOfSegmentAndPeriod(k, sensitivity.getSensitivityVariable1Period()), sensitivityGenericSheet, false);
                    }
                } else {
                    originalVariable1Value[0] = this.getValueForVariableAtPeriod(variable1.get(), variable1.get().columnOfSegmentAndPeriod(-1, sensitivity.getSensitivityVariable1Period()), sensitivityGenericSheet, false);
                }
                if (variable2.get().isModelledAtSegment() && !this.model.getSegments().isEmpty()) {
                    for (k = 0; k < this.model.getSegments().size(); ++k) {
                        originalVariable2Value[k] = this.getValueForVariableAtPeriod(variable2.get(), variable2.get().columnOfSegmentAndPeriod(k, sensitivity.getSensitivityVariable2Period()), sensitivityGenericSheet, false);
                    }
                } else {
                    originalVariable2Value[0] = this.getValueForVariableAtPeriod(variable2.get(), variable2.get().columnOfSegmentAndPeriod(-1, sensitivity.getSensitivityVariable2Period()), sensitivityGenericSheet, false);
                }
                if (measurementVariable.get().isModelledAtSegment() && !this.model.getSegments().isEmpty()) {
                    for (k = 0; k <= this.model.getSegments().size(); ++k) {
                        int segmentIndex = k - 1;
                        originalMeasurementValue[k] = this.getValueForVariableAtPeriod(measurementVariable.get(), measurementVariable.get().columnOfSegmentAndPeriod(segmentIndex, sensitivity.getSensitivityMeasurementVariablePeriod()), sensitivityGenericSheet, false);
                    }
                } else {
                    originalMeasurementValue[0] = this.getValueForVariableAtPeriod(measurementVariable.get(), measurementVariable.get().columnOfSegmentAndPeriod(-1, sensitivity.getSensitivityMeasurementVariablePeriod()), sensitivityGenericSheet, false);
                }
                int variable1Offset = sensitivity.getSensitivityVariable1Steps() / 2;
                int variable2Offset = sensitivity.getSensitivityVariable2Steps() / 2;
                for (int h = 0; h < numberOfMeasurementSegments; ++h) {
                    log.debug("Original value: {} from column: {} from row: {} ", (Object)originalMeasurementValue[h], (Object)column, (Object)measurementVariable.get().getRow());
                    for (int i = 0; i < sensitivity.getSensitivityVariable1Steps(); ++i) {
                        double variable1Value = (float)(i - variable1Offset) * sensitivity.getSensitivityVariable1StepSize().floatValue();
                        if (!variable1.get().isModelledAtSegment() || this.model.getSegments().isEmpty()) {
                            variable1Value = originalVariable1Value[0] + (double)((float)(i - variable1Offset) * sensitivity.getSensitivityVariable1StepSize().floatValue());
                        }
                        sensitivityResult.setVariable1Values(i, variable1Value);
                        for (int j = 0; j < sensitivity.getSensitivityVariable2Steps(); ++j) {
                            int k2;
                            ArrayList<GenericSheet.CellValue> cellsToBeUpdated = new ArrayList<GenericSheet.CellValue>();
                            double variable2Value = (float)(j - variable2Offset) * sensitivity.getSensitivityVariable2StepSize().floatValue();
                            if (!variable2.get().isModelledAtSegment() || this.model.getSegments().isEmpty()) {
                                variable2Value = originalVariable2Value[0] + (double)((float)(j - variable2Offset) * sensitivity.getSensitivityVariable2StepSize().floatValue());
                            }
                            if (i == 0) {
                                sensitivityResult.setVariable2Values(j, variable2Value);
                            }
                            if (variable1.get().isModelledAtSegment() && !this.model.getSegments().isEmpty()) {
                                for (k2 = 0; k2 < this.model.getSegments().size(); ++k2) {
                                    variable1Value = originalVariable1Value[k2] + (double)((float)(i - variable1Offset) * sensitivity.getSensitivityVariable1StepSize().floatValue());
                                    cellsToBeUpdated.add(new GenericSheet.CellValue(variable1Value, variable1.get().columnOfSegmentAndPeriod(k2, sensitivity.getSensitivityVariable1Period()), variable1.get().getRow()));
                                }
                            } else {
                                cellsToBeUpdated.add(new GenericSheet.CellValue(variable1Value, variable1.get().columnOfSegmentAndPeriod(-1, sensitivity.getSensitivityVariable1Period()), variable1.get().getRow()));
                            }
                            if (variable2.get().isModelledAtSegment() && !this.model.getSegments().isEmpty()) {
                                for (k2 = 0; k2 < this.model.getSegments().size(); ++k2) {
                                    variable2Value = originalVariable2Value[k2] + (double)((float)(j - variable2Offset) * sensitivity.getSensitivityVariable2StepSize().floatValue());
                                    cellsToBeUpdated.add(new GenericSheet.CellValue(variable2Value, variable2.get().columnOfSegmentAndPeriod(k2, sensitivity.getSensitivityVariable2Period()), variable2.get().getRow()));
                                }
                            } else {
                                cellsToBeUpdated.add(new GenericSheet.CellValue(variable2Value, variable2.get().columnOfSegmentAndPeriod(-1, sensitivity.getSensitivityVariable2Period()), variable2.get().getRow()));
                            }
                            GenericSheet.CellValue[] cellsToBeUpdatedArray = new GenericSheet.CellValue[cellsToBeUpdated.size()];
                            cellsToBeUpdatedArray = cellsToBeUpdated.toArray(cellsToBeUpdatedArray);
                            sensitivityGenericSheet.setCellValues(cellsToBeUpdatedArray);
                            sensitivityGenericSheet.computeCellValues(cellsToBeUpdatedArray);
                            double measuredValue = this.getValueForVariableAtPeriod(measurementVariable.get(), measurementVariable.get().columnOfSegmentAndPeriod(h - 1, sensitivity.getSensitivityMeasurementVariablePeriod()), sensitivityGenericSheet, true);
                            sensitivityResult.setMyResultArray(h, i, j, measuredValue);
                        }
                    }
                }
                sensitivityResult.setValid(true);
                sensitivityResults.add(sensitivityResult);
                this.calcDocument.remove(sensitivityGenericSheet);
            }
            catch (Exception e) {
                log.error("Error when running sensitivity", (Throwable)e);
            }
        }
        return sensitivityResults;
    }

    private double getValueForVariableAtPeriod(Variable variable, int column, GenericSheet genericSheet, boolean computeCell) {
        if (computeCell) {
            genericSheet.computeCell(column, variable.getRow());
        }
        return genericSheet.getValueWithoutRecalculation(column, variable.getRow());
    }
}

