package app.valuationcontrol.webservice.enin;

import app.valuationcontrol.webservice.enin.records.CompanyNameRecord;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.extern.log4j.Log4j2;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Log4j2
public class EninController {

  private final EninAPIService eninAPIService;

  public EninController(EninAPIService eninAPIService) {
    this.eninAPIService = eninAPIService;
  }

  @Operation(summary = "This method is used to search for existing compnies")
  @GetMapping("/api/searchcompany")
  public ResponseEntity<CompanyNameRecord[]> searchEninForCompanies(
      @Parameter(description = "the name of the company to be found") @RequestParam()
          String companyName) {
    return ResponseEntity.ok(eninAPIService.getCompanies(companyName));
  }
}
