package app.valuationcontrol.webservice.helpers;

import java.util.Comparator;

/**
 * Helper class to help with search and replace while evaluating formula.
 *
 * @author thoma
 */
public record StringReplacer(String searchString, Integer modifier) {

  /*Comparator for sorting the list by Search Variable descending areaOrder*/
  public static final Comparator<StringReplacer> StringReplacerComparatorDesc =
      (v1, v2) -> {
        Integer stringReplacerLength1 = v1.searchString().length();
        Integer stringReplacerLength2 = v2.searchString().length();

        // Descending areaOrder
        return stringReplacerLength2.compareTo(stringReplacerLength1);
      };
}
