package app.valuationcontrol.webservice.model.events.listeners.logger;

import app.valuationcontrol.webservice.model.events.Event;
import app.valuationcontrol.webservice.model.logentry.LogEntry;
import app.valuationcontrol.webservice.model.logentry.LogEntryRepository;
import app.valuationcontrol.webservice.model.variablevalue.VariableValue;
import java.time.LocalDateTime;
import lombok.extern.log4j.Log4j2;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@Log4j2
public class VariableValueLogger {

  private static final String ADDED_VARIABLE_VALUE_FOR = "Added variable value";
  private static final String REMOVED_VARIABLE_VALUE_FOR = "Removed variable value";
  private static final String UPDATED_VARIABLE_VALUE_FOR = "Updated variable value";

  private final LogEntryRepository logEntryRepository;

  public VariableValueLogger(LogEntryRepository logEntryRepository) {
    this.logEntryRepository = logEntryRepository;
  }

  @EventListener
  public void onEvent(Event<VariableValue> event) {
    // Event<VariableValue> event = (Event<VariableValue>) genericEvent;

    VariableValue vv = event.effectedEntity();

    final LogEntry.LogEntryBuilder logEntryBuilder =
        LogEntry.builder()
            .username(event.getPrincipal().getName())
            .changeDate(LocalDateTime.now())
            .fromFormula("")
            .toFormula("")
            .variableId(vv.getAttachedVariable().getId())
            .attachedModel(vv.getAttachedVariable().getAttachedModel())
            .period(vv.getPeriod());

    switch (event.getType()) {
      case CREATED -> {
        LogEntry entry =
            logEntryBuilder
                .fromValue(null)
                .toValue(vv.getValue())
                .action(ADDED_VARIABLE_VALUE_FOR)
                .build();

        logEntryRepository.save(entry);
      }
      case DELETED -> {
        LogEntry entry =
            logEntryBuilder
                .action(REMOVED_VARIABLE_VALUE_FOR)
                .fromValue(vv.getValue())
                .toValue(null)
                .build();

        logEntryRepository.save(entry);
      }
      case UPDATED, METADATA_UPDATE -> {
        LogEntry entry =
            logEntryBuilder
                .fromValue((event.getOldVersion()).getValue())
                .toValue((event.getNewVersion()).getValue())
                .action(UPDATED_VARIABLE_VALUE_FOR)
                .build();

        logEntryRepository.save(entry);
      }
    }
  }
}
