package app.valuationcontrol.webservice.securityhelpers;

import app.valuationcontrol.webservice.securityhelpers.stompInterceptors.TopicSubscriptionInterceptor;
import app.valuationcontrol.webservice.securityhelpers.stompInterceptors.VerifyConnectInterceptor;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;

@Component
@Configuration
@EnableWebSocketMessageBroker
@Order(Ordered.HIGHEST_PRECEDENCE + 99)
@Log4j2
public class WebSocketConfiguration implements WebSocketMessageBrokerConfigurer {

  private static final String MESSAGE_PREFIX = "/topic";

  private final JwtDecoder jwtDecoder;
  private final JwtAuthenticationConverter jwtAuthenticationConverter;
  private final AllowedOrigins allowedOrigins;

  @Autowired
  public WebSocketConfiguration(
      JwtDecoder jwtDecoder,
      JwtAuthenticationConverter jwtAuthenticationConverter,
      AllowedOrigins allowedOrigins) {
    this.jwtDecoder = jwtDecoder;
    this.jwtAuthenticationConverter = jwtAuthenticationConverter;
    this.allowedOrigins = allowedOrigins;
  }

  @Override
  public void registerStompEndpoints(StompEndpointRegistry registry) {
    registry
        .addEndpoint("/events")
        .setAllowedOrigins(allowedOrigins.getAllowedOrigins().toArray(new String[0]))
        .withSockJS();
  }

  @Override
  public void configureMessageBroker(MessageBrokerRegistry registry) {
    registry.enableSimpleBroker(MESSAGE_PREFIX);
  }

  @Override
  public void configureClientInboundChannel(ChannelRegistration registration) {
    registration.interceptors(
        new VerifyConnectInterceptor(
            jwtDecoder,
            jwtAuthenticationConverter), // Verifying that the user exists to allow connection
        new TopicSubscriptionInterceptor()); // Verifying that the user has access to model to allow
    // subscription
  }
}
