package app.valuationcontrol.webservice.user;

import app.valuationcontrol.webservice.model.Model;
import java.util.ArrayList;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface UserRepository extends JpaRepository<User, Long> {

  @Query("select u from User u LEFT JOIN FETCH u.modelRoles where u.email = ?1")
  User findByEmail(String userEmail);

  @Query("select u from User u LEFT JOIN FETCH u.modelRoles where KEY(u.modelRoles) = ?1")
  ArrayList<User> findByModel(Model model);
}
