/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.enin;

import app.valuationcontrol.webservice.enin.EninAPIService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.RequestEntity;
import org.springframework.security.oauth2.client.ClientCredentialsOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.endpoint.DefaultClientCredentialsTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequestEntityConverter;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.reactive.function.client.ServletOAuth2AuthorizedClientExchangeFilterFunction;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@ComponentScan(basePackageClasses={EninAPIService.class})
public class WebClientConfig {
    @Bean
    public WebClient webClientAnalysis(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientRepository authorizedClientRepository) {
        DefaultClientCredentialsTokenResponseClient clientCredentialsTokenResponseClient = new DefaultClientCredentialsTokenResponseClient();
        clientCredentialsTokenResponseClient.setRequestEntityConverter(WebClientConfig.parametersConverterRequest((String)"analysis"));
        ClientCredentialsOAuth2AuthorizedClientProvider clientCredentialsOAuth2AuthorizedClientProvider = new ClientCredentialsOAuth2AuthorizedClientProvider();
        clientCredentialsOAuth2AuthorizedClientProvider.setAccessTokenResponseClient((OAuth2AccessTokenResponseClient)clientCredentialsTokenResponseClient);
        DefaultOAuth2AuthorizedClientManager authorizedClientManager = new DefaultOAuth2AuthorizedClientManager(clientRegistrationRepository, authorizedClientRepository);
        authorizedClientManager.setAuthorizedClientProvider((OAuth2AuthorizedClientProvider)clientCredentialsOAuth2AuthorizedClientProvider);
        ServletOAuth2AuthorizedClientExchangeFilterFunction oauth2Client = new ServletOAuth2AuthorizedClientExchangeFilterFunction((OAuth2AuthorizedClientManager)authorizedClientManager);
        oauth2Client.setDefaultClientRegistrationId("eninDatasets");
        return WebClient.builder().filter((ExchangeFilterFunction)oauth2Client).build();
    }

    @Bean
    public WebClient webClientDataset(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientRepository authorizedClientRepository) {
        DefaultClientCredentialsTokenResponseClient clientCredentialsTokenResponseClient = new DefaultClientCredentialsTokenResponseClient();
        clientCredentialsTokenResponseClient.setRequestEntityConverter(WebClientConfig.parametersConverterRequest((String)"datasets"));
        ClientCredentialsOAuth2AuthorizedClientProvider clientCredentialsOAuth2AuthorizedClientProvider = new ClientCredentialsOAuth2AuthorizedClientProvider();
        clientCredentialsOAuth2AuthorizedClientProvider.setAccessTokenResponseClient((OAuth2AccessTokenResponseClient)clientCredentialsTokenResponseClient);
        DefaultOAuth2AuthorizedClientManager authorizedClientManager = new DefaultOAuth2AuthorizedClientManager(clientRegistrationRepository, authorizedClientRepository);
        authorizedClientManager.setAuthorizedClientProvider((OAuth2AuthorizedClientProvider)clientCredentialsOAuth2AuthorizedClientProvider);
        ServletOAuth2AuthorizedClientExchangeFilterFunction oauth2Client = new ServletOAuth2AuthorizedClientExchangeFilterFunction((OAuth2AuthorizedClientManager)authorizedClientManager);
        oauth2Client.setDefaultClientRegistrationId("eninAnalysis");
        return WebClient.builder().filter((ExchangeFilterFunction)oauth2Client).build();
    }

    private static Converter<OAuth2ClientCredentialsGrantRequest, MultiValueMap<String, String>> parametersConverterMap(String audienceAccessPoint) {
        return grantRequest -> {
            LinkedMultiValueMap parameters = new LinkedMultiValueMap();
            parameters.set((Object)"audience", (Object)("https://api.enin.ai/" + audienceAccessPoint));
            return parameters;
        };
    }

    private static Converter<OAuth2ClientCredentialsGrantRequest, RequestEntity<?>> parametersConverterRequest(String audienceAccessPoint) {
        return grantRequest -> {
            OAuth2ClientCredentialsGrantRequestEntityConverter requestEntityConverter = new OAuth2ClientCredentialsGrantRequestEntityConverter();
            requestEntityConverter.addParametersConverter(WebClientConfig.parametersConverterMap((String)audienceAccessPoint));
            return requestEntityConverter.convert((AbstractOAuth2AuthorizationGrantRequest)grantRequest);
        };
    }
}

