/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.helpers.exceptions;

import app.valuationcontrol.webservice.helpers.exceptions.ResourceException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class ExceptionHandlerAdvice {
    private static final Logger log = LogManager.getLogger(ExceptionHandlerAdvice.class);

    @ExceptionHandler(value={ResourceException.class})
    public ResponseEntity<String> handleException(ResourceException e) {
        return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)e.getHttpStatus());
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public ResponseEntity<String> handleAccessDeniedException(AccessDeniedException e) {
        return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<Map<String, List<String>>> handleValidationErrors(MethodArgumentNotValidException ex) {
        List errors = ex.getBindingResult().getFieldErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.toList());
        log.info(errors);
        return new ResponseEntity((Object)this.getErrorsMap(errors), (MultiValueMap)new HttpHeaders(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    private Map<String, List<String>> getErrorsMap(List<String> errors) {
        HashMap<String, List<String>> errorResponse = new HashMap<String, List<String>>();
        errorResponse.put("errors", errors);
        return errorResponse;
    }
}

