/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model;

import app.valuationcontrol.webservice.EntityService;
import app.valuationcontrol.webservice.enin.EninAPIService;
import app.valuationcontrol.webservice.enin.EninMappingToTemplate;
import app.valuationcontrol.webservice.enin.records.BalanceSheetRecord;
import app.valuationcontrol.webservice.enin.records.CompanyNameRecord;
import app.valuationcontrol.webservice.enin.records.EninCompanyRecord;
import app.valuationcontrol.webservice.enin.records.IncomeStatementRecord;
import app.valuationcontrol.webservice.helpers.CalculationData;
import app.valuationcontrol.webservice.helpers.FormulaEvaluator;
import app.valuationcontrol.webservice.helpers.ModelProvider;
import app.valuationcontrol.webservice.helpers.exceptions.ResourceException;
import app.valuationcontrol.webservice.model.KeyParam;
import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.ModelData;
import app.valuationcontrol.webservice.model.ModelRepository;
import app.valuationcontrol.webservice.model.ScenarioComparison;
import app.valuationcontrol.webservice.model.area.Area;
import app.valuationcontrol.webservice.model.events.Event;
import app.valuationcontrol.webservice.model.events.Events;
import app.valuationcontrol.webservice.model.graph.ModelGraph;
import app.valuationcontrol.webservice.model.segment.Segment;
import app.valuationcontrol.webservice.model.sensitivity.Sensitivity;
import app.valuationcontrol.webservice.model.subarea.SubArea;
import app.valuationcontrol.webservice.model.variable.Variable;
import app.valuationcontrol.webservice.model.variable.VariableRepository;
import app.valuationcontrol.webservice.model.variablevalue.VariableValue;
import app.valuationcontrol.webservice.openai.OpenAiServiceImplementation;
import app.valuationcontrol.webservice.presentation.PresentationManager;
import app.valuationcontrol.webservice.user.UserRepository;
import app.valuationcontrol.webservice.xlhandler.CalcDocument;
import app.valuationcontrol.webservice.xlhandler.POICalcDocument;
import app.valuationcontrol.webservice.xlhandler.SCENARIO;
import app.valuationcontrol.webservice.xlhandler.ScenarioDataProvider;
import app.valuationcontrol.webservice.xlhandler.XLHandleManager;
import app.valuationcontrol.webservice.xlhandler.XLInstance;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
public class ModelController {
    private static final Logger log = LogManager.getLogger(ModelController.class);
    public static final String MODEL_ID = "modelId";
    public static final String MODEL_ID_DESCRIPTION = "The id of the model to be amended or deleted";
    private final ModelRepository modelRepository;
    private final VariableRepository variableRepository;
    private final XLHandleManager xlHandleManager;
    private final EntityService entityService;
    private final UserRepository userRepository;
    private final Events events;
    private final EninAPIService eninAPIService;
    private final OpenAiServiceImplementation openAiServiceImplementation;

    public ModelController(ModelRepository modelRepository, VariableRepository variableRepository, XLHandleManager xlHandleManager, EntityService entityService, UserRepository userRepository, Events events, EninAPIService eninAPIService, OpenAiServiceImplementation openAiServiceImplementation) {
        this.modelRepository = modelRepository;
        this.variableRepository = variableRepository;
        this.xlHandleManager = xlHandleManager;
        this.entityService = entityService;
        this.userRepository = userRepository;
        this.events = events;
        this.eninAPIService = eninAPIService;
        this.openAiServiceImplementation = openAiServiceImplementation;
    }

    @Operation(summary="This method is used to run tests", hidden=true)
    @GetMapping(value={"/api/cypress/{modelId}"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'READER')")
    public ResponseEntity<List<String>> cypress(@PathVariable(value="modelId") Model model) {
        ArrayList cypressCommands = new ArrayList();
        System.out.println("Long zoneId, subZoneId, variableId;");
        model.getSegments().forEach(segment -> System.out.println("Long segment" + segment.getId() + " = addSegment(\"" + segment.getSegmentName() + "\", \"" + segment.getSegmentCurrency() + "\");"));
        model.getAreas().forEach(area -> {
            System.out.println("zoneId = addZone(\"" + area.getAreaName() + "\", \"" + area.getAreaDescription() + "\");");
            area.getSubAreas().forEach(subArea -> {
                System.out.println("subZoneId = addSubZone(\"" + subArea.getSubAreaName() + "\", \"" + subArea.getSubAreaDescription() + "\", zoneId, " + subArea.isModelledAtSegment() + ");");
                model.getVariables().stream().filter(variable -> variable.getVariableSubAreaId().longValue() == subArea.getId()).forEach(variable -> {
                    System.out.println("variableId = addVariableToAreaSubarea(\"" + variable.getVariableName() + "\", \"" + variable.getVariableFormula() + "\", \"" + variable.getVariableType() + "\", \"" + variable.getVariableFormat() + "\",zoneId,subZoneId);");
                    variable.getVariableValues().forEach(variableValue -> System.out.println("super.createVariableValue(new VariableValueData(-1, " + String.valueOf(variableValue.getPeriod() != null ? variableValue.getPeriod() : "-1") + ", " + variableValue.getValue() + "f, null," + variableValue.getScenarioNumber() + ", " + (variableValue.getAttachedSegment() != null ? "segment" + variableValue.getAttachedSegment().getId() : null) + "), variableId);"));
                });
            });
        });
        return ResponseEntity.ok(cypressCommands);
    }

    @Operation(summary="Create a new model from Enin company data", description="Use this entrypoint to bootstrap a model from EninData", responses={@ApiResponse(responseCode="201", description="the id of the created model"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @PostMapping(value={"/api/modelenin"})
    public ResponseEntity<Long> createModelFromEnin(@Parameter(description="a JSON object containing the company details") @RequestBody @Valid CompanyNameRecord companyNameRecord, @Parameter(description="the start year for the model") @RequestParam Integer startYear, @Parameter(description="A name for the created model") @RequestParam(defaultValue="Valuation model") String modelName, @Parameter(description="Boolean that indicates whether to import group figures") @RequestParam(defaultValue="false") boolean doImportGroupFigures, @Parameter(description="Indicates the unitDivider") @RequestParam(defaultValue="1000") Integer unitDivider, Principal principal) {
        String currency;
        switch (unitDivider) {
            case 1000000: {
                String string = "NOKm";
                break;
            }
            case 1000000000: {
                String string = "NOKb";
                break;
            }
            default: {
                String string = currency = "NOKk";
            }
        }
        if (!(!doImportGroupFigures || ((String)modelName).contains("group") && ((String)modelName).contains("konsern"))) {
            modelName = (String)modelName + " (Group)";
        }
        ModelData modelData = new ModelData(Long.valueOf(-1L), (String)modelName, startYear, Integer.valueOf(3), Integer.valueOf(10), companyNameRecord.company().name(), companyNameRecord.company().org_nr_schema() + companyNameRecord.company().org_nr(), currency, "template", false, false, null);
        Long modelId = (Long)this.addModel(modelData, Long.valueOf(626L), false, principal).getBody();
        assert (modelId != null);
        Model model = (Model)this.modelRepository.getReferenceById((Object)modelId);
        this.updateModelWithEninData(model, unitDivider, Boolean.valueOf(doImportGroupFigures), principal);
        return ResponseEntity.ok((Object)modelId);
    }

    private void updateModelWithEninData(@Parameter(description="The id of the model to be amended or deleted", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model, Integer unitDivider, Boolean doImportGroupFigures, Principal principal) {
        EninCompanyRecord eninCompanyRecord = this.eninAPIService.getCompanyRecord(model.getCompanyNumber(), doImportGroupFigures.booleanValue());
        log.info(model.getCompanyNumber());
        EninMappingToTemplate.getMappingMap().forEach((key, value) -> {
            log.info("Checking value " + value + " for key " + key);
            Optional<Variable> variable = model.getVariables().stream().filter(v -> v.getVariableName().equals(key)).findFirst();
            if (variable.isPresent()) {
                log.info("Found " + variable.get().getVariableName());
                variable.get().getVariableValues().clear();
                for (int i = -model.getNbHistoricalPeriod().intValue(); i < 0; ++i) {
                    Integer accounting_year = model.getStartYear() + i;
                    Integer index = i;
                    Optional<IncomeStatementRecord> eisr = Arrays.stream(eninCompanyRecord.incomeStatementRecords()).filter(r -> r.accounting_year().equals(accounting_year)).findFirst();
                    Optional<BalanceSheetRecord> ebsr = Arrays.stream(eninCompanyRecord.balanceSheetRecords()).filter(r -> r.accounting_year().equals(accounting_year)).findFirst();
                    StandardEvaluationContext context = new StandardEvaluationContext();
                    eisr.ifPresent(arg_0 -> ModelController.lambda$updateModelWithEninData$9((EvaluationContext)context, arg_0));
                    ebsr.ifPresent(arg_0 -> ModelController.lambda$updateModelWithEninData$10((EvaluationContext)context, arg_0));
                    if (!eisr.isPresent() || !ebsr.isPresent()) continue;
                    Float eninValue = (Float)new SpelExpressionParser().parseExpression(value).getValue((EvaluationContext)context, Float.class);
                    log.debug((Object)eninValue);
                    if (eninValue == null) continue;
                    VariableValue vv = new VariableValue();
                    vv.setAttachedVariable(variable.get());
                    vv.setValue(Float.valueOf(eninValue.floatValue() / (float)unitDivider.intValue()));
                    vv.setPeriod(index);
                    vv.setScenarioNumber(Integer.valueOf(0));
                    vv.setEditor(principal.getName());
                    vv.setSourceFile("Enin API");
                    variable.get().getVariableValues().add(vv);
                    Event event = Event.created((Object)this, (Object)vv, (Principal)principal, VariableValue.class, (Model)model);
                    this.events.publishCustomEvent(event);
                }
            }
        });
        this.events.processEvents(principal);
    }

    @Operation(summary="Add a new model", description="Use this entrypoint to add a new model or replicate an existing one using the template id paramater", responses={@ApiResponse(responseCode="201", description="the id of the created model"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @PostMapping(value={"/api/model"})
    @PreAuthorize(value="authentication.principal.hasAccessToTemplate(#templateId)")
    public ResponseEntity<Long> addModel(@Parameter(description="a JSON object containing the model data") @RequestBody @Valid ModelData modelData, @Parameter(description="the id of the template model") @RequestParam(required=false, defaultValue="-1") Long templateId, @Parameter(description="A boolean indicating whether to copy existing values from template model") @RequestParam(required=false, defaultValue="true") boolean copyVariableValues, Principal principal) {
        Model newModel = new Model(modelData);
        newModel.setKeyParam(new KeyParam());
        if (templateId == -1L) {
            return this.entityService.safeCreate(Model.class, (Object)newModel, new ModelProvider[0]).map(model -> {
                Event modelEvent = Event.created((Object)this, (Object)model, (Principal)principal, Model.class, (Model)model);
                this.events.publishCustomEvent(modelEvent);
                return new ResponseEntity((Object)model.getId(), (HttpStatusCode)HttpStatus.CREATED);
            }).orElse(ResponseEntity.badRequest().build());
        }
        return this.modelRepository.findById((Object)templateId).map(templateModel -> {
            KeyParam keyParam = new KeyParam();
            keyParam.copyFromExisting(templateModel.getKeyParam(), newModel);
            newModel.setKeyParam(keyParam);
            newModel.setTemplateId(templateId);
            newModel.setSimpleModel(templateModel.getSimpleModel());
            Model createdModel = (Model)this.entityService.create(Model.class, (Object)newModel);
            Event modelEvent = Event.created((Object)this, (Object)createdModel, (Principal)principal, Model.class, (Model)createdModel);
            this.events.publishCustomEvent(modelEvent);
            this.copyAreasAndSubAreasSegmentsAndVariableValues(createdModel, templateModel, copyVariableValues);
            Map<Long, Long> idMap = createdModel.getVariables().stream().distinct().collect(Collectors.toMap(Variable::getOriginalId, Variable::getId));
            this.copyGraphs(createdModel, templateModel, idMap);
            this.copySensitivities(createdModel, templateModel, idMap);
            keyParam.replaceIds(idMap);
            this.initiateFormulas(createdModel);
            return new ResponseEntity((Object)((Model)this.entityService.update(Model.class, (Object)newModel)).getId(), (HttpStatusCode)HttpStatus.CREATED);
        }).orElse(ResponseEntity.badRequest().build());
    }

    @Operation(summary="Lock a model for changes", responses={@ApiResponse(responseCode="200", description="Successfull operation"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @PatchMapping(value={"/api/model/{modelId}/lock"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'ADMIN')")
    public ResponseEntity<String> lockModel(@Parameter(description="The id of the model to be amended or deleted", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model, Principal principal) {
        model.setLocked(true);
        Event event = Event.lightUpdated((Object)this, (Object)model, (Principal)principal, Model.class, (Model)model);
        this.events.publishCustomEvent(event);
        this.events.processEvents(principal);
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Unlock a model for changes", responses={@ApiResponse(responseCode="200", description="Successfull operation"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @PatchMapping(value={"/api/model/{modelId}/unlock"})
    @PreAuthorize(value="authentication.principal.canUnlock(#model,'ADMIN')")
    public ResponseEntity<String> unlockModel(@Parameter(description="The id of the model to be amended or deleted", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model, Principal principal) {
        model.setLocked(false);
        Event event = Event.lightUpdated((Object)this, (Object)model, (Principal)principal, Model.class, (Model)model);
        this.events.publishCustomEvent(event);
        this.events.processEvents(principal);
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Update a model", description="Use this entrypoint to update an existing model", responses={@ApiResponse(responseCode="200", description="Successfull operation"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @PutMapping(value={"/api/model/{modelId}"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'ADMIN')")
    public ResponseEntity<String> updateModel(@Parameter(description="The id of the model to be amended or deleted", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model, @RequestBody @Valid ModelData modelData, Principal principal) {
        Model oldModel = new Model(model.asData());
        model.setSimpleModel(modelData.simpleModel());
        model.setCurrency(modelData.currency());
        model.setName(modelData.name());
        model.setCompany(modelData.company());
        model.setCompanyNumber(modelData.companyNumber());
        model.setLocked(modelData.locked());
        model.setIncludeYTD(modelData.includeYTD());
        Event event = Event.updated((Object)this, (Object)oldModel, (Object)model, (Principal)principal, Model.class, (Model)model);
        this.events.publishCustomEvent(event);
        this.events.processEvents(principal);
        return ResponseEntity.ok().build();
    }

    private void copySensitivities(Model newModel, Model templateModel, Map<Long, Long> idMap) {
        templateModel.getSensitivities().forEach(sensitivity -> {
            Sensitivity newSensitivity = new Sensitivity(sensitivity);
            newSensitivity.setAttachedModel(newModel);
            newSensitivity.setId(Long.valueOf(-1L));
            if (sensitivity.getSensitivityVariable1Id() != null) {
                newSensitivity.setSensitivityVariable1Id((Long)idMap.get(sensitivity.getSensitivityVariable1Id()));
            }
            if (sensitivity.getSensitivityVariable2Id() != null) {
                newSensitivity.setSensitivityVariable2Id((Long)idMap.get(sensitivity.getSensitivityVariable2Id()));
            }
            if (sensitivity.getSensitivityMeasurementVariableId() != null) {
                newSensitivity.setSensitivityMeasurementVariableId((Long)idMap.get(sensitivity.getSensitivityMeasurementVariableId()));
            }
            this.entityService.create(Sensitivity.class, (Object)newSensitivity);
        });
    }

    private void copyGraphs(Model newModel, Model templateModel, Map<Long, Long> idMap) {
        templateModel.getGraphs().forEach(modelGraph -> {
            ModelGraph newModelGraph = new ModelGraph(modelGraph);
            newModelGraph.setAttachedModel(newModel);
            if (modelGraph.getGraphVariable1Id() != null) {
                newModelGraph.setGraphVariable1Id((Long)idMap.get(modelGraph.getGraphVariable1Id()));
            }
            if (modelGraph.getGraphVariable2Id() != null) {
                newModelGraph.setGraphVariable2Id((Long)idMap.get(modelGraph.getGraphVariable2Id()));
            }
            if (modelGraph.getGraphVariable3Id() != null) {
                newModelGraph.setGraphVariable3Id((Long)idMap.get(modelGraph.getGraphVariable3Id()));
            }
            this.entityService.create(ModelGraph.class, (Object)newModelGraph);
        });
    }

    private void copyAreasAndSubAreasSegmentsAndVariableValues(Model newModel, Model templateModel, boolean copyVariableValues) {
        HashMap oldIdToNewSegmentId = new HashMap();
        templateModel.getSegments().forEach(segment -> {
            Segment segmentCopy = new Segment(segment.asData(), newModel);
            oldIdToNewSegmentId.put(segment.getId(), (Segment)this.entityService.create(Segment.class, (Object)segmentCopy));
        });
        for (Area area : templateModel.getAreas()) {
            Area areaCopy = new Area(newModel, area.getAreaName(), area.getAreaDescription(), area.getAreaOrder());
            newModel.getAreas().add(areaCopy);
            areaCopy = (Area)this.entityService.create(Area.class, (Object)areaCopy);
            this.copySubAreasAndVariableValues(area, areaCopy, templateModel, newModel, oldIdToNewSegmentId, copyVariableValues);
        }
    }

    private void copySubAreasAndVariableValues(Area originalArea, Area areaCopy, Model templateModel, Model newModel, Map<Long, Segment> oldIdToNewSegmentId, boolean copyVariableValues) {
        for (SubArea subArea : originalArea.getSubAreas()) {
            SubArea subAreaCopy = new SubArea(subArea);
            subAreaCopy.setAttachedArea(areaCopy);
            subAreaCopy = (SubArea)this.entityService.create(SubArea.class, (Object)subAreaCopy);
            for (Variable variable : templateModel.getVariables()) {
                if (variable.getVariableSubArea() != subArea) continue;
                Variable variableCopy = new Variable(variable, subAreaCopy);
                variableCopy.setOriginalId(variable.getId());
                Variable createdVariable = (Variable)this.entityService.create(Variable.class, (Object)variableCopy);
                newModel.getVariables().add(createdVariable);
                AtomicInteger periodOffset = new AtomicInteger(0);
                if (!Objects.equals(newModel.getStartYear(), templateModel.getStartYear())) {
                    periodOffset.set(templateModel.getStartYear() - newModel.getStartYear());
                }
                if (!copyVariableValues) continue;
                this.copyVariableValues(newModel, oldIdToNewSegmentId, variable, variableCopy, createdVariable, periodOffset);
            }
        }
    }

    private void copyVariableValues(Model newModel, Map<Long, Segment> oldIdToNewSegmentId, Variable variable, Variable variableCopy, Variable createdVariable, AtomicInteger periodOffset) {
        variable.getVariableValues().forEach(variableValue -> {
            Integer newPeriod;
            VariableValue copy = new VariableValue(variableValue.asData(), variableCopy);
            Integer n = newPeriod = copy.getPeriod() != null ? Integer.valueOf(copy.getPeriod() + periodOffset.get()) : null;
            if (newPeriod == null || newPeriod >= -newModel.getNbHistoricalPeriod().intValue() && newPeriod < newModel.getNbProjectionPeriod()) {
                copy.setPeriod(newPeriod);
                if (variableValue.getAttachedSegment() != null) {
                    copy.setAttachedSegment((Segment)oldIdToNewSegmentId.get(variableValue.getAttachedSegment().getId()));
                }
                VariableValue createdVariableValue = (VariableValue)this.entityService.create(VariableValue.class, (Object)copy);
                createdVariable.getVariableValues().add(createdVariableValue);
            }
        });
    }

    public void initiateFormulas(Model model) {
        for (Variable variable : model.getVariables()) {
            if (!variable.getVariableType().equals("constant")) {
                if (variable.getEvaluatedVariableFormula() != null && (!variable.getVariableDependencies().isEmpty() || variable.getVariableType().equals("input"))) continue;
                variable.setEvaluatedVariableFormula(FormulaEvaluator.evaluateVariableFormula((Variable)variable));
                continue;
            }
            if (variable.getEvaluatedVariableFormula() != null) continue;
            variable.setEvaluatedVariableFormula(FormulaEvaluator.evaluateVariableFormula((Variable)variable));
        }
        this.variableRepository.saveAll((Iterable)model.getVariables());
    }

    @Operation(summary="Delete a model", description="Use this entrypoint to delete an existing model", responses={@ApiResponse(responseCode="200", description="Successfull operation"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @DeleteMapping(value={"/api/model/{modelId}"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'ADMIN')")
    public ResponseEntity<Void> deleteModel(@Parameter(description="The id of the model to be amended or deleted", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model, Principal principal) {
        ArrayList byModel = this.userRepository.findByModel(model);
        byModel.forEach(user -> {
            user.getModelRoles().remove(model);
            this.userRepository.saveAndFlush(user);
        });
        Event event = Event.deleted((Object)this, (Object)model, (Principal)principal, Model.class, (Model)model);
        this.events.publishCustomEvent(event);
        this.events.processEvents(principal);
        this.entityService.safeDelete(Model.class, (Object)model, new ModelProvider[0]);
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Update the key parameters of an existing model", description="Use this entrypoint to update the key parameters of an existing model (main outputs and key values drivers)", responses={@ApiResponse(responseCode="200", description="Successfull operation"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @PutMapping(value={"/api/model/{modelId}/keyparam"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<String> updateKeyParam(@Parameter(description="The id of the model to be amended or deleted", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model, @Parameter(description="A JSON Object specifying the key parameters and outputs of the model") @RequestBody @Valid KeyParam keyParam, Principal principal) {
        model.setKeyParam(keyParam);
        this.safeSetPeriod(keyParam.getKeyOutput1Id(), arg_0 -> ((KeyParam)keyParam).setKeyOutput1Period(arg_0), keyParam.getKeyOutput1Period());
        this.safeSetPeriod(keyParam.getKeyOutput2Id(), arg_0 -> ((KeyParam)keyParam).setKeyOutput2Period(arg_0), keyParam.getKeyOutput2Period());
        this.safeSetPeriod(keyParam.getKeyParam1Id(), arg_0 -> ((KeyParam)keyParam).setKeyParam1Period(arg_0), keyParam.getKeyParam1Period());
        this.safeSetPeriod(keyParam.getKeyParam2Id(), arg_0 -> ((KeyParam)keyParam).setKeyParam2Period(arg_0), keyParam.getKeyParam2Period());
        this.safeSetPeriod(keyParam.getKeyParam3Id(), arg_0 -> ((KeyParam)keyParam).setKeyParam3Period(arg_0), keyParam.getKeyParam3Period());
        this.safeSetPeriod(keyParam.getKeyParam4Id(), arg_0 -> ((KeyParam)keyParam).setKeyParam4Period(arg_0), keyParam.getKeyParam4Period());
        Event modelEvent = Event.lightUpdated((Object)this, (Object)model, (Principal)principal, Model.class, (Model)model);
        this.events.publishCustomEvent(modelEvent);
        this.events.processEvents(principal);
        return ResponseEntity.ok().build();
    }

    private void safeSetPeriod(Long id, IntConsumer setValue, Integer period) {
        this.variableRepository.findById((Object)id).ifPresent(variable -> {
            if (variable.isSingleOrConstantValue()) {
                setValue.accept(0);
            } else {
                try {
                    setValue.accept(Sensitivity.fromYear((Integer)period, (Model)variable.getAttachedModel()));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    setValue.accept(0);
                }
            }
        });
    }

    @Operation(summary="Get the model's metadata", description="Use this entrypoint to fetch the model's metadata (no values)", responses={@ApiResponse(responseCode="200", description="Successfull operation"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @GetMapping(value={"/api/model/{modelId}/metadata"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'READER')")
    public ResponseEntity<CalculationData> getMetadata(@Parameter(description="The id of the model to be amended or deleted", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model, @Parameter(description="the scenario number to fetch - (0-4) with default 0") @RequestParam(defaultValue="0") Integer scenarioNumber) {
        CalculationData content = new CalculationData(model, null, null, null, scenarioNumber.intValue());
        return ResponseEntity.ok().body((Object)content);
    }

    @Operation(summary="Get the model's metadata and calculations", description="Use this entrypoint to fetch the model's metadata and values", responses={@ApiResponse(responseCode="200", description="Successfull operation"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @GetMapping(value={"/api/model/{modelId}/calculation"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'READER')")
    public ResponseEntity<CalculationData> getCalculation(@Parameter(description="The id of the model to be amended or deleted", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model, @Parameter(description="the scenario number to fetch - (0-4) with default 0") @RequestParam(defaultValue="0") Integer scenarioNumber) {
        CalculationData content = this.xlHandleManager.getXLInstanceForModel(model).getContent(SCENARIO.from((int)scenarioNumber));
        return ResponseEntity.ok().body((Object)content);
    }

    @Operation(summary="Returns a simple excel file containing all variables", description="Use this entrypoint to fetch an Excel file containing all variables", responses={@ApiResponse(responseCode="200", description="Successfull operation"), @ApiResponse(responseCode="400", description="Invalid request parameters or empty model with no variables"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @GetMapping(value={"/api/model/{modelId}/getExcel"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'READER')")
    ResponseEntity<byte[]> getModelAsExcel(@Parameter(description="The id of the model to be amended or deleted", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model) {
        if (model.getVariables().isEmpty()) {
            throw new ResourceException(HttpStatus.BAD_REQUEST, "Cannot export a model without any variable");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment; filename=model.xlsx");
        headers.setContentType(new MediaType("application", "vnd.openxmlformats-officedocument.spreadsheetml.sheet"));
        try {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)this.xlHandleManager.getXLInstanceForModel(model).saveAs().readAllBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Operation(summary="Get the model's metadata and calculations", description="Use this entrypoint to fetch the model's metadata and values", responses={@ApiResponse(responseCode="200", description="Successfull operation"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @GetMapping(value={"/api/model/{modelId}/getPresentation"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'READER')")
    ResponseEntity<byte[]> getModelAsPPTX(@Parameter(description="The id of the model to be amended or deleted", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model, @Parameter(description="A boolean indicating whether to include AI comments in the presentation") @RequestParam(required=false, defaultValue="false") boolean includeAIComments) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment; filename=model.pptx");
        headers.setContentType(new MediaType("application", "vnd.openxmlformats-officedocument.presentationml.presentation"));
        try {
            ScenarioDataProvider scenarioDataProvider = this.xlHandleManager.getXLInstanceForModel(model);
            scenarioDataProvider.runSensitivities(model.getSensitivities(), SCENARIO.BASE);
            model.getSensitivities().forEach(sensitivity -> sensitivity.setSensitivityLastRun(LocalDateTime.now()));
            CalculationData calculationData = scenarioDataProvider.getContent(SCENARIO.BASE);
            PresentationManager presentationManager = new PresentationManager(model, calculationData, this.openAiServiceImplementation);
            presentationManager.createSummary();
            presentationManager.createCharts(includeAIComments);
            presentationManager.createSensitivities(includeAIComments);
            ScenarioComparison comparisons = Objects.requireNonNull((ScenarioComparison)this.getComparison(model).getBody());
            if (!comparisons.comparisons().isEmpty()) {
                presentationManager.createComparison(comparisons, includeAIComments);
            }
            calculationData.getAreas().forEach(a -> a.subAreas().forEach(sa -> presentationManager.createTable(sa.id(), SCENARIO.BASE, a.areaName() + " - " + sa.subAreaName())));
            ByteArrayOutputStream outputStream1 = new ByteArrayOutputStream();
            presentationManager.getSlideShow().write((OutputStream)outputStream1);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)new ByteArrayInputStream(outputStream1.toByteArray()).readAllBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Operation(summary="This method is used to test that the application is up and running, returns pong", hidden=true)
    @GetMapping(value={"/api/ping"})
    public String debug() {
        return "pong";
    }

    @Operation(summary="Compare key variables in the model across the scenarios", description="Compare the key variables across the scenarios used in the model (key parameters, graphs and sensitivities) and returns an ", responses={@ApiResponse(responseCode="200", description="Successfull operation"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @GetMapping(value={"/api/model/{modelId}/comparison"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'READER')")
    public ResponseEntity<ScenarioComparison> getComparison(@Parameter(description="The id of the model to be amended or deleted", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model) {
        Set keyVariables = model.getKeyVariablesForModel();
        ArrayList<CalculationData> scenarioCalculationData = new ArrayList<CalculationData>();
        XLInstance xlInstanceForModel = new XLInstance(model, (CalcDocument)new POICalcDocument(), null);
        for (int i = 0; i < 5; ++i) {
            scenarioCalculationData.add(xlInstanceForModel.getContent(SCENARIO.from((int)i)));
        }
        ArrayList comparisonStructure = new ArrayList();
        for (Long variableId : keyVariables) {
            List data = scenarioCalculationData.stream().flatMap(calculationData -> calculationData.getVariables().stream().filter(variableData -> Objects.equals(variableData.id(), variableId))).toList();
            comparisonStructure.add(data);
        }
        return ResponseEntity.ok((Object)new ScenarioComparison(comparisonStructure));
    }

    private static /* synthetic */ void lambda$updateModelWithEninData$10(EvaluationContext context, BalanceSheetRecord balanceSheetRecord) {
        context.setVariable("ebsr", (Object)balanceSheetRecord);
    }

    private static /* synthetic */ void lambda$updateModelWithEninData$9(EvaluationContext context, IncomeStatementRecord incomeStatementRecord) {
        context.setVariable("eisr", (Object)incomeStatementRecord);
    }
}

