/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.area;

import app.valuationcontrol.webservice.helpers.DataTransformer;
import app.valuationcontrol.webservice.helpers.EntityDTOConverter;
import app.valuationcontrol.webservice.helpers.ModelProvider;
import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.area.AreaData;
import app.valuationcontrol.webservice.model.subarea.SubArea;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"attached_model_id", "area_name"})})
public class Area
implements DataTransformer<AreaData>,
ModelProvider {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @ManyToOne
    private Model attachedModel;
    @Column(name="area_name")
    private String areaName;
    @Column(name="area_description")
    private String areaDescription;
    @Column(name="area_order")
    private Integer areaOrder;
    @OneToMany(mappedBy="attachedArea", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="subAreaOrder ASC")
    private List<SubArea> subAreas = new ArrayList();

    public Area(AreaData areaData, Model model) {
        this.updateFrom(areaData);
        this.attachedModel = model;
        this.setAreaOrder(Integer.valueOf(model.getAreas().size() + 1));
    }

    public Area(Model attachedModel, String areaName, String description, Integer order) {
        this.attachedModel = attachedModel;
        this.areaName = areaName;
        this.areaDescription = description;
        this.areaOrder = order;
    }

    public Area(Area existingArea) {
        this.attachedModel = existingArea.getAttachedModel();
        this.areaName = existingArea.getAreaName();
        this.areaDescription = existingArea.getAreaDescription();
        this.areaOrder = existingArea.getAreaOrder();
        this.subAreas = existingArea.getSubAreas();
    }

    public AreaData asData() {
        List subAreaData = EntityDTOConverter.asData((List)this.subAreas);
        return new AreaData(Long.valueOf(this.id), this.areaName, this.areaDescription, this.areaOrder, subAreaData);
    }

    public Long getModelId() {
        return this.attachedModel.getId();
    }

    public void updateFrom(AreaData areaData) {
        this.areaName = areaData.areaName();
        this.areaDescription = areaData.areaDescription();
    }

    public long getId() {
        return this.id;
    }

    public Model getAttachedModel() {
        return this.attachedModel;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getAreaDescription() {
        return this.areaDescription;
    }

    public Integer getAreaOrder() {
        return this.areaOrder;
    }

    public List<SubArea> getSubAreas() {
        return this.subAreas;
    }

    public Area() {
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setAttachedModel(Model attachedModel) {
        this.attachedModel = attachedModel;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public void setAreaDescription(String areaDescription) {
        this.areaDescription = areaDescription;
    }

    public void setAreaOrder(Integer areaOrder) {
        this.areaOrder = areaOrder;
    }
}

