/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.events;

import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.events.Event;
import app.valuationcontrol.webservice.model.sensitivity.Sensitivity;
import app.valuationcontrol.webservice.model.subarea.SubArea;
import app.valuationcontrol.webservice.model.variablevalue.VariableValue;
import app.valuationcontrol.webservice.xlhandler.ScenarioDataProvider;
import app.valuationcontrol.webservice.xlhandler.XLHandleManager;
import java.security.Principal;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class Events {
    private static final Logger log = LogManager.getLogger(Events.class);
    private final ConcurrentLinkedQueue<Event<?>> eventsToTreat;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final XLHandleManager xlHandleManager;

    @Autowired
    public Events(ApplicationEventPublisher applicationEventPublisher, XLHandleManager xlHandleManager) {
        this.applicationEventPublisher = applicationEventPublisher;
        this.xlHandleManager = xlHandleManager;
        this.eventsToTreat = new ConcurrentLinkedQueue();
    }

    public void publishCustomEvent(Event<?> customEvent) {
        log.debug("Publishing custom event. " + customEvent.getParameterClass());
        this.eventsToTreat.add(customEvent);
        this.applicationEventPublisher.publishEvent(customEvent);
    }

    public void processEvents(Principal p) {
        log.debug("processing events ");
        List<Event> principalEvents = this.getEventsToTreat().stream().filter(e -> e.getPrincipal().getName().equals(p.getName())).toList();
        if (Objects.equals(principalEvents.size(), 1)) {
            log.debug("Start - Single events detected -> Remaining events" + (long)this.getEventsToTreat().size());
            Event e2 = principalEvents.get(0);
            log.debug("Event was removed" + this.getEventsToTreat().remove(e2));
            if (e2 != null) {
                if (e2.isMetadataUpdate()) {
                    this.lightReload(e2.getModel());
                } else {
                    switch (e2.getParameterClass()) {
                        case "VariableValue": {
                            this.onVariableValueEvent(e2.getModel(), e2);
                            break;
                        }
                        case "SubArea": {
                            this.onSubAreaEvent(e2.getModel(), e2);
                            break;
                        }
                        case "Sensitivity": {
                            this.onSensitivityEvent(e2.getModel(), e2);
                            break;
                        }
                        case "Segment": {
                            this.onSegmentEvent(e2.getModel(), e2);
                            break;
                        }
                        default: {
                            this.fullReload(e2.getModel());
                        }
                    }
                }
            }
            log.debug("Stop - Single event detected -> Remaining events" + this.getEventsToTreat().size());
        } else if (principalEvents.size() > 1) {
            log.debug("Multiple events detected -> Remaining events" + this.getEventsToTreat().size());
            principalEvents.stream().map(e -> {
                this.getEventsToTreat().remove(e);
                return e.getModel();
            }).distinct().forEach(m -> {
                log.debug("Reloading model  " + m.getId());
                this.getInstance(m).clearCacheAndReloadAndUpdateClients();
            });
            log.debug("Multiple events detected -> Remaining events" + this.getEventsToTreat().size());
        }
    }

    public ScenarioDataProvider getInstance(Model model) {
        return this.xlHandleManager.getXLInstanceForModel(model);
    }

    private void lightReload(Model model) {
        this.getInstance(model).reloadAndUpdateClients();
    }

    private void fullReload(Model model) {
        this.getInstance(model).clearCacheAndReloadAndUpdateClients();
    }

    private void onVariableValueEvent(Model model, Event<?> event) {
        if (!event.isDelete()) {
            this.getInstance(model).refreshValue(((VariableValue)event.getNewVersion()).getAttachedVariable(), (VariableValue)event.getNewVersion());
        } else {
            this.getInstance(model).reloadVariableAndUpdateCache(((VariableValue)event.getOldVersion()).getAttachedVariable());
        }
        this.lightReload(model);
    }

    private void onSubAreaEvent(Model model, Event<?> event) {
        if (event.isUpdate()) {
            SubArea oldVersion = (SubArea)event.getOldVersion();
            SubArea newVersion = (SubArea)event.getNewVersion();
            if (oldVersion.isModelledAtSegment() != newVersion.isModelledAtSegment()) {
                this.fullReload(model);
            } else {
                this.lightReload(model);
            }
        } else {
            this.lightReload(model);
        }
    }

    private void onSensitivityEvent(Model model, Event<?> sensitivityEvent) {
        if (sensitivityEvent.isDelete()) {
            this.getInstance(model).getSensitivityResults().removeIf(sensitivityResult -> ((Sensitivity)sensitivityEvent.effectedEntity()).getId().equals(sensitivityResult.getId()));
        }
        this.lightReload(model);
    }

    private void onSegmentEvent(Model model, Event<?> tEvent) {
        if (tEvent.isDelete() || tEvent.isCreate()) {
            this.fullReload(model);
        } else {
            this.lightReload(model);
        }
    }

    public ConcurrentLinkedQueue<Event<?>> getEventsToTreat() {
        return this.eventsToTreat;
    }
}

