/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.graph;

import app.valuationcontrol.webservice.helpers.DataTransformer;
import app.valuationcontrol.webservice.helpers.ModelProvider;
import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.graph.ModelGraphData;
import app.valuationcontrol.webservice.model.variable.Variable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import java.util.Objects;
import java.util.Optional;

@Entity
public class ModelGraph
implements DataTransformer<ModelGraphData>,
ModelProvider {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="graph_id")
    private Long id;
    @ManyToOne
    private Model attachedModel;
    private String graphName;
    private String graphDescription;
    private Long graphVariable1Id;
    private Long graphVariable2Id;
    private Long graphVariable3Id;
    private String graphVariable1Type;
    private String graphVariable2Type;
    private String graphVariable3Type;
    private String graphVariable1Axis;
    private String graphVariable2Axis;
    private String graphVariable3Axis;
    private Boolean graphIncludeHistoricals;

    public ModelGraph() {
    }

    public ModelGraph(ModelGraphData modelGraphData, Model model) {
        this.updateFrom(modelGraphData);
        this.attachedModel = model;
    }

    public ModelGraph(ModelGraph existingGraph) {
        this(existingGraph.asData(), existingGraph.attachedModel);
    }

    public void updateFrom(ModelGraphData graphData) {
        this.graphName = graphData.graphName();
        this.graphDescription = graphData.graphDescription();
        this.graphVariable1Id = graphData.graphVariable1Id();
        this.graphVariable2Id = graphData.graphVariable2Id();
        this.graphVariable3Id = graphData.graphVariable3Id();
        this.graphVariable1Type = graphData.graphVariable1Type();
        this.graphVariable2Type = graphData.graphVariable2Type();
        this.graphVariable3Type = graphData.graphVariable3Type();
        this.graphVariable1Axis = graphData.graphVariable1Axis();
        this.graphVariable2Axis = graphData.graphVariable2Axis();
        this.graphVariable3Axis = graphData.graphVariable3Axis();
        this.graphIncludeHistoricals = graphData.graphIncludeHistoricals();
    }

    public boolean useSegmentAxis() {
        Optional<Variable> variable1 = this.attachedModel.getVariables().stream().filter(variable -> Objects.equals(variable.getId(), this.graphVariable1Id)).findFirst();
        return variable1.isPresent() && variable1.get().isSingleOrConstantValue() && variable1.get().isModelledAtSegment();
    }

    public ModelGraphData asData() {
        return new ModelGraphData(this.id, this.graphName, this.graphDescription, Long.valueOf(Objects.isNull(this.graphVariable1Id) ? -1L : this.graphVariable1Id), Long.valueOf(Objects.isNull(this.graphVariable2Id) ? -1L : this.graphVariable2Id), Long.valueOf(Objects.isNull(this.graphVariable3Id) ? -1L : this.graphVariable3Id), this.graphVariable1Type, this.graphVariable2Type, this.graphVariable3Type, this.graphVariable1Axis, this.graphVariable2Axis, this.graphVariable3Axis, this.graphIncludeHistoricals);
    }

    public Long getModelId() {
        return this.getAttachedModel().getId();
    }

    public ModelGraph setAttachedModel(Model attachedModel) {
        this.attachedModel = attachedModel;
        return this;
    }

    public void setGraphVariable1Id(Long graphVariable1Id) {
        this.graphVariable1Id = graphVariable1Id;
    }

    public void setGraphVariable2Id(Long graphVariable2Id) {
        this.graphVariable2Id = graphVariable2Id;
    }

    public void setGraphVariable3Id(Long graphVariable3Id) {
        this.graphVariable3Id = graphVariable3Id;
    }

    public int getNumberOfVariables() {
        return (Objects.requireNonNullElse(this.graphVariable1Id, -1L) > 0L ? 1 : 0) + (Objects.requireNonNullElse(this.graphVariable2Id, -1L) > 0L ? 1 : 0) + (Objects.requireNonNullElse(this.graphVariable3Id, -1L) > 0L ? 1 : 0);
    }

    public int getNumberOfDifferentAxis() {
        int returnInt = 1;
        if (this.graphVariable1Axis.equalsIgnoreCase("secondary") && (this.graphVariable2Axis.equalsIgnoreCase("primary") || this.graphVariable3Axis.equalsIgnoreCase("primary")) || this.graphVariable2Axis.equalsIgnoreCase("secondary") && (this.graphVariable1Axis.equalsIgnoreCase("primary") || this.graphVariable3Axis.equalsIgnoreCase("primary")) || this.graphVariable3Axis.equalsIgnoreCase("secondary") && (this.graphVariable1Axis.equalsIgnoreCase("primary") || this.graphVariable2Axis.equalsIgnoreCase("primary"))) {
            ++returnInt;
        }
        return returnInt;
    }

    public boolean useTwoAxis() {
        return Integer.valueOf(Math.min(this.getNumberOfDifferentAxis(), this.getNumberOfVariables())).equals(2);
    }

    public Long getId() {
        return this.id;
    }

    public Model getAttachedModel() {
        return this.attachedModel;
    }

    public String getGraphName() {
        return this.graphName;
    }

    public String getGraphDescription() {
        return this.graphDescription;
    }

    public Long getGraphVariable1Id() {
        return this.graphVariable1Id;
    }

    public Long getGraphVariable2Id() {
        return this.graphVariable2Id;
    }

    public Long getGraphVariable3Id() {
        return this.graphVariable3Id;
    }

    public String getGraphVariable1Type() {
        return this.graphVariable1Type;
    }

    public String getGraphVariable2Type() {
        return this.graphVariable2Type;
    }

    public String getGraphVariable3Type() {
        return this.graphVariable3Type;
    }

    public String getGraphVariable1Axis() {
        return this.graphVariable1Axis;
    }

    public String getGraphVariable2Axis() {
        return this.graphVariable2Axis;
    }

    public String getGraphVariable3Axis() {
        return this.graphVariable3Axis;
    }

    public Boolean getGraphIncludeHistoricals() {
        return this.graphIncludeHistoricals;
    }

    public void setGraphVariable1Axis(String graphVariable1Axis) {
        this.graphVariable1Axis = graphVariable1Axis;
    }

    public void setGraphVariable2Axis(String graphVariable2Axis) {
        this.graphVariable2Axis = graphVariable2Axis;
    }

    public void setGraphVariable3Axis(String graphVariable3Axis) {
        this.graphVariable3Axis = graphVariable3Axis;
    }
}

