/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.logentry;

import app.valuationcontrol.webservice.helpers.EntityDTOConverter;
import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.logentry.LogEntryData;
import app.valuationcontrol.webservice.model.logentry.LogEntryRepository;
import app.valuationcontrol.webservice.model.sensitivity.Sensitivity;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LogEntryController {
    private final LogEntryRepository logEntryRepository;

    public LogEntryController(LogEntryRepository logEntryRepository) {
        this.logEntryRepository = logEntryRepository;
    }

    @GetMapping(value={"/api/model/{modelId}/logentry"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'READER')")
    public ResponseEntity<List<LogEntryData>> getLogs(@PathVariable(value="modelId") Model model, Pageable pageable) {
        List allByModel = this.logEntryRepository.findAllByModel(model.getModelId().longValue(), pageable);
        allByModel.forEach(logEntry -> logEntry.setPeriod(Sensitivity.asModelYear((Integer)logEntry.getPeriod(), (Model)model)));
        return ResponseEntity.ok((Object)EntityDTOConverter.asData((List)allByModel));
    }
}

