/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.segment;

import app.valuationcontrol.webservice.EntityService;
import app.valuationcontrol.webservice.helpers.ModelChecker;
import app.valuationcontrol.webservice.helpers.ModelProvider;
import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.events.Event;
import app.valuationcontrol.webservice.model.events.Events;
import app.valuationcontrol.webservice.model.segment.Segment;
import app.valuationcontrol.webservice.model.segment.SegmentData;
import app.valuationcontrol.webservice.model.segment.SegmentWithVariableValues;
import app.valuationcontrol.webservice.model.variable.VariableController;
import app.valuationcontrol.webservice.model.variable.VariableRepository;
import app.valuationcontrol.webservice.model.variablevalue.VariableValue;
import app.valuationcontrol.webservice.model.variablevalue.VariableValueData;
import app.valuationcontrol.webservice.model.variablevalue.VariableValueRepository;
import app.valuationcontrol.webservice.xlhandler.XLHandleManager;
import jakarta.transaction.Transactional;
import jakarta.validation.Valid;
import java.security.Principal;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@Transactional
@RestController
public class SegmentController {
    private final EntityService entityService;
    private final VariableValueRepository variableValueRepository;
    private final Events events;

    public SegmentController(EntityService entityService, VariableValueRepository variableValueRepository, XLHandleManager xlHandleManager, VariableController variableController, VariableRepository variableRepository, Events events) {
        this.entityService = entityService;
        this.variableValueRepository = variableValueRepository;
        this.events = events;
    }

    @PostMapping(value={"/api/model/{modelId}/segment"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<Long> addSegment(@PathVariable(value="modelId") Model model, @Valid @RequestBody SegmentData segmentData, Principal principal) {
        Segment segment = new Segment(segmentData, model);
        return this.entityService.safeCreate(Segment.class, (Object)segment, new ModelProvider[0]).map(segment1 -> {
            Event event = Event.created((Object)this, (Object)segment1, (Principal)principal, Segment.class, (Model)model);
            this.events.publishCustomEvent(event);
            this.events.processEvents(principal);
            return new ResponseEntity((Object)segment1.getId(), (HttpStatusCode)HttpStatus.CREATED);
        }).orElse(ResponseEntity.badRequest().build());
    }

    @PutMapping(value={"/api/model/{modelId}/segment/{segmentId}"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<String> updateSegment(@PathVariable(value="modelId") Model model, @PathVariable(value="segmentId") Segment segment, @Valid @RequestBody SegmentData segmentData, Principal principal) {
        if (!ModelChecker.inSameModel((ModelProvider[])new ModelProvider[]{model, segment})) {
            return ResponseEntity.badRequest().build();
        }
        Segment oldSegment = new Segment(segment);
        segment.updateFrom(segmentData, model);
        Event event = Event.updated((Object)this, (Object)oldSegment, (Object)segment, (Principal)principal, Segment.class, (Model)model);
        this.events.publishCustomEvent(event);
        this.events.processEvents(principal);
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"/api/model/{modelId}/segment/{segmentId}"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<String> deleteSegment(@PathVariable(value="modelId") Model model, @PathVariable(value="segmentId") Segment segment, Principal principal) {
        if (!ModelChecker.inSameModel((ModelProvider[])new ModelProvider[]{model, segment})) {
            return ResponseEntity.badRequest().build();
        }
        this.variableValueRepository.findSegmentVariables(segment.getId()).forEach(variableValue -> variableValue.getAttachedVariable().getVariableValues().remove(variableValue));
        model.getSegments().remove(segment);
        Event event = Event.deleted((Object)this, (Object)segment, (Principal)principal, Segment.class, (Model)model);
        this.events.publishCustomEvent(event);
        this.events.processEvents(principal);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/api/model/{modelId}/segmentwithvariablevalues"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<Long> addSegmentWithVariableValues(@PathVariable(value="modelId") Model model, @Valid @RequestBody SegmentWithVariableValues segmentWithVariableValues, Principal principal) {
        Segment segment = new Segment(segmentWithVariableValues.segmentData(), model);
        for (VariableValueData variableValueData : segmentWithVariableValues.variableValues()) {
            model.getVariableWithID(variableValueData.attachedVariableId().longValue()).ifPresentOrElse(variable -> {
                if (!ModelChecker.inSameModel((ModelProvider[])new ModelProvider[]{model, variable, segment})) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST);
                }
                if (!variable.isModelledAtSegment()) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST);
                }
                if (variableValueData.value() == null) {
                    return;
                }
                VariableValue variableValue = new VariableValue(variableValueData, variable);
                variableValue.setAttachedSegment(segment);
                variableValue.setEditor(principal.getName());
                variableValue.setSourceFile("Manually registered");
                variable.getVariableValues().add(variableValue);
                Event variableValueEvent = Event.created((Object)this, (Object)variableValue, (Principal)principal, VariableValue.class, (Model)model);
                this.events.publishCustomEvent(variableValueEvent);
            }, () -> {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST);
            });
        }
        model.getSegments().add(segment);
        Event segmentEvent = Event.created((Object)this, (Object)segment, (Principal)principal, Segment.class, (Model)model);
        this.events.publishCustomEvent(segmentEvent);
        this.events.processEvents(principal);
        return new ResponseEntity((Object)segment.getId(), (HttpStatusCode)HttpStatus.CREATED);
    }
}

