/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.sensitivity;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class SensitivityResult {
    private Long id = null;
    boolean isValid = false;
    private BigDecimal[] variable1Values;
    private BigDecimal[] variable2Values;
    private BigDecimal[][][] myResultArray;
    private Integer scenarioNumber;

    public SensitivityResult() {
    }

    public SensitivityResult(Long id, Integer scenarioNumber, Integer variable1Steps, Integer variable2Steps, Integer numberOfSegments) {
        this.id = id;
        this.scenarioNumber = scenarioNumber;
        this.variable1Values = new BigDecimal[variable1Steps.intValue()];
        this.variable2Values = new BigDecimal[variable2Steps.intValue()];
        this.myResultArray = new BigDecimal[numberOfSegments.intValue()][variable1Steps.intValue()][variable2Steps.intValue()];
        this.isValid = true;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public BigDecimal convertToBigDecimal(Double value) {
        BigDecimal temp = new BigDecimal(value);
        temp = temp.setScale(3, RoundingMode.HALF_UP);
        return temp;
    }

    public void setVariable1Values(int i, Double insertValue) {
        this.variable1Values[i] = this.convertToBigDecimal(insertValue);
    }

    public void setVariable2Values(int i, Double insertValue) {
        this.variable2Values[i] = this.convertToBigDecimal(insertValue);
    }

    public void setMyResultArray(int segmentIndex, int i, int j, double value) {
        this.myResultArray[segmentIndex][i][j] = this.convertToBigDecimal(Double.valueOf(value));
    }

    public Long getId() {
        return this.id;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public BigDecimal[] getVariable1Values() {
        return this.variable1Values;
    }

    public BigDecimal[] getVariable2Values() {
        return this.variable2Values;
    }

    public BigDecimal[][][] getMyResultArray() {
        return this.myResultArray;
    }

    public Integer getScenarioNumber() {
        return this.scenarioNumber;
    }
}

