/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.subarea;

import app.valuationcontrol.webservice.EntityService;
import app.valuationcontrol.webservice.helpers.ModelChecker;
import app.valuationcontrol.webservice.helpers.ModelProvider;
import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.area.Area;
import app.valuationcontrol.webservice.model.events.Event;
import app.valuationcontrol.webservice.model.events.Events;
import app.valuationcontrol.webservice.model.events.listeners.AuditLog;
import app.valuationcontrol.webservice.model.subarea.SubArea;
import app.valuationcontrol.webservice.model.subarea.SubAreaData;
import jakarta.validation.Valid;
import java.security.Principal;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SubAreaController {
    private static final String SWAPPED_SUB_AREA_ORDER = "Change order of %s and %s";
    private final EntityService entityService;
    private final AuditLog auditLog;
    private final Events events;

    public SubAreaController(EntityService entityService, AuditLog auditLog, Events events) {
        this.entityService = entityService;
        this.events = events;
        this.auditLog = auditLog;
    }

    @PostMapping(value={"/api/model/{modelId}/area/{areaId}/subarea"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<Long> addSubArea(@PathVariable(value="modelId") Model model, @PathVariable(value="areaId") Area area, @Valid @RequestBody SubAreaData subAreaData, Principal principal) {
        SubArea subArea = new SubArea(subAreaData, area);
        area.getSubAreas().add(subArea);
        return this.entityService.safeCreate(SubArea.class, (Object)subArea, new ModelProvider[]{model, area}).map(createdSubArea -> {
            Event event = Event.created((Object)this, (Object)createdSubArea, (Principal)principal, SubArea.class, (Model)model);
            this.events.publishCustomEvent(event);
            this.events.processEvents(principal);
            return new ResponseEntity((Object)createdSubArea.getId(), (HttpStatusCode)HttpStatus.CREATED);
        }).orElse(ResponseEntity.badRequest().build());
    }

    @PutMapping(value={"/api/model/{modelId}/area/{areaId}/subarea/{subAreaId}"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<String> updateSubArea(@PathVariable(value="modelId") Model model, @PathVariable(value="areaId") Area area, @PathVariable(value="subAreaId") SubArea subArea, @Valid @RequestBody SubAreaData subAreaData, Principal principal) {
        if (!ModelChecker.inSameModel((ModelProvider[])new ModelProvider[]{model, area, subArea})) {
            return ResponseEntity.badRequest().build();
        }
        SubArea oldSubArea = new SubArea(subArea);
        subArea.updateWith(subAreaData, area);
        Event event = Event.updated((Object)this, (Object)oldSubArea, (Object)subArea, (Principal)principal, SubArea.class, (Model)model);
        this.events.publishCustomEvent(event);
        this.events.processEvents(principal);
        return ResponseEntity.ok((Object)String.valueOf(subArea.getId()));
    }

    @PostMapping(value={"/api/model/{modelId}/area/{areaId}/swap/{subAreaId1}/{subAreaId2}"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<String> swapSubAreas(@PathVariable(value="modelId") Model model, @PathVariable(value="areaId") Area area, @PathVariable(value="subAreaId1") SubArea subArea1, @PathVariable(value="subAreaId2") SubArea subArea2, Principal principal) {
        if (!ModelChecker.inSameModel((ModelProvider[])new ModelProvider[]{model, area, subArea1, subArea2})) {
            return ResponseEntity.badRequest().build();
        }
        int subArea1OrderBefore = subArea1.getSubAreaOrder();
        subArea1.setSubAreaOrder(subArea2.getSubAreaOrder());
        subArea2.setSubAreaOrder(Integer.valueOf(subArea1OrderBefore));
        Event event = Event.lightUpdated((Object)this, (Object)model, (Principal)principal, Model.class, (Model)model);
        this.events.publishCustomEvent(event);
        this.events.processEvents(principal);
        this.auditLog.log(area.getAttachedModel(), String.format(SWAPPED_SUB_AREA_ORDER, subArea1.getSubAreaName(), subArea2.getSubAreaName()), principal);
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"/api/model/{modelId}/area/{areaId}/subarea/{subAreaId}"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<String> deleteArea(@PathVariable(value="modelId") Model model, @PathVariable(value="areaId") Area area, @PathVariable(value="subAreaId") SubArea subArea, Principal principal) {
        if (!ModelChecker.inSameModel((ModelProvider[])new ModelProvider[]{model, area, subArea})) {
            return ResponseEntity.badRequest().build();
        }
        long numberOfVariablesInSubArea = model.getVariables().stream().filter(variable -> variable.getVariableSubArea().getId() == subArea.getId()).count();
        if (numberOfVariablesInSubArea > 0L) {
            return ResponseEntity.badRequest().body((Object)("Cannot delete subarea with " + numberOfVariablesInSubArea + " variables still connected to it"));
        }
        area.getSubAreas().remove(subArea);
        Event event = Event.deleted((Object)this, (Object)subArea, (Principal)principal, SubArea.class, (Model)model);
        this.events.publishCustomEvent(event);
        this.events.processEvents(principal);
        return ResponseEntity.ok().build();
    }
}

