/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.openai;

import app.valuationcontrol.webservice.openai.records.ReviewResponse;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatFunction;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.service.FunctionExecutor;
import com.theokanning.openai.service.OpenAiService;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class OpenAiServiceImplementation {
    OpenAiService openAiService;
    String model;

    @Autowired
    public OpenAiServiceImplementation(Environment environment) {
        if (environment != null) {
            this.openAiService = new OpenAiService(environment.getProperty("openai.key", ""), Duration.ofSeconds(45L));
            this.model = environment.getProperty("openai.model", "");
        }
    }

    public ChatCompletionRequest getChatRequestWithFunction(List<ChatMessage> messages, FunctionExecutor functionExecutor, String functionName) {
        return ChatCompletionRequest.builder().model(this.model).temperature(Double.valueOf(0.8)).messages(messages).functions(functionExecutor.getFunctions()).functionCall(ChatCompletionRequest.ChatCompletionRequestFunctionCall.of((String)functionName)).n(Integer.valueOf(1)).logitBias(new HashMap()).build();
    }

    public ChatCompletionRequest getChatRequest(List<ChatMessage> messages) {
        return ChatCompletionRequest.builder().model(this.model).temperature(Double.valueOf(0.8)).messages(messages).n(Integer.valueOf(1)).logitBias(new HashMap()).build();
    }

    public FunctionExecutor getReviewFunction() {
        return new FunctionExecutor(Collections.singletonList(ChatFunction.builder().name("get_review").description("Get the review of the current variable").executor(ReviewResponse.class, r -> new ReviewResponse(r.variableId(), r.score(), r.explanation(), r.suggestion())).build()));
    }

    public OpenAiService getOpenAiService() {
        return this.openAiService;
    }

    public String getModel() {
        return this.model;
    }
}

