/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.securityhelpers;

import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.stereotype.Component;

@Component
public class CustomAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LogManager.getLogger(CustomAuthenticationProvider.class);
    @Autowired
    UserDetailsService myUserDetailsService;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        log.debug("Authenticate: Checking user {}, is authenticated: {}", (Object)authentication.getName(), (Object)authentication.isAuthenticated());
        String customToken = (String)authentication.getPrincipal();
        String modelId = (String)authentication.getCredentials();
        return this.getValidationToken(customToken, modelId);
    }

    private Authentication getValidationToken(String username, String modelId) {
        UserDetails currentUser;
        ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
        if (username != null && (currentUser = this.myUserDetailsService.loadUserByUsername(username)) != null) {
            grantedAuthorities.add(new SimpleGrantedAuthority("ROLE_User"));
            UsernamePasswordAuthenticationToken returnAuth = new UsernamePasswordAuthenticationToken((Object)currentUser, (Object)modelId, grantedAuthorities);
            return returnAuth;
        }
        throw new AuthenticationCredentialsNotFoundException("Couldn't find a user");
    }

    public boolean supports(Class<?> authentication) {
        return PreAuthenticatedAuthenticationToken.class.equals(authentication);
    }
}

