/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.securityhelpers;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class GlobalExceptionHandlers {
    private static final Logger log = LogManager.getLogger(GlobalExceptionHandlers.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<List<FieldError>> handleMethodArgumentNotValidException(HttpServletRequest request, MethodArgumentNotValidException ex) {
        log.error("Could not create method argument", (Throwable)ex);
        BindingResult result = ex.getBindingResult();
        List fieldErrors = result.getFieldErrors();
        return ResponseEntity.badRequest().body((Object)fieldErrors);
    }

    @ExceptionHandler(value={NullPointerException.class})
    public ResponseEntity<String> handleNullPointerException(HttpServletRequest request, NullPointerException exception) {
        return ResponseEntity.badRequest().body((Object)exception.getMessage());
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    public ResponseEntity<Object> handleSqlException(DataIntegrityViolationException ex) {
        Throwable throwable;
        if (ex.getCause() != null && ex.getCause().getCause() != null && (throwable = ex.getCause().getCause()) instanceof PSQLException) {
            PSQLException psqlException = (PSQLException)throwable;
            if (PSQLState.UNIQUE_VIOLATION.getState().equals(psqlException.getSQLState()) && psqlException.getServerErrorMessage() != null && psqlException.getServerErrorMessage().getTable() != null) {
                String table = psqlException.getServerErrorMessage().getTable();
                return ResponseEntity.badRequest().body((Object)("A " + ("area".equals(table) ? "zone" : table) + " with that same name already exists"));
            }
        }
        return ResponseEntity.badRequest().body((Object)ex.getCause());
    }
}

