/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.securityhelpers;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Date;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class JwtTokenUtil {
    private final Environment environment;

    @Autowired
    private JwtTokenUtil(Environment environment) {
        this.environment = environment;
    }

    private byte[] getSecret() {
        String secret = this.environment.getProperty("jwt.secret");
        if (secret == null) {
            throw new IllegalStateException("No secret configured in key jwt.secret");
        }
        return secret.getBytes();
    }

    public String getUsernameFromToken(String token) {
        return (String)this.getClaimFromToken(token, Claims::getSubject);
    }

    public <T> T getClaimFromToken(String token, Function<Claims, T> claimsResolver) {
        Claims claims = this.getAllClaimsFromToken(token);
        if (claims != null) {
            return claimsResolver.apply(claims);
        }
        return null;
    }

    private Claims getAllClaimsFromToken(String token) {
        Claims returnClaims;
        try {
            returnClaims = (Claims)Jwts.parserBuilder().setSigningKey(this.getSecret()).build().parseClaimsJws(token).getBody();
        }
        catch (ExpiredJwtException E) {
            returnClaims = null;
        }
        return returnClaims;
    }

    public String generateToken(String username, Date expiration) {
        return Jwts.builder().setSubject(username).setExpiration(expiration).signWith((Key)Keys.hmacShaKeyFor((byte[])this.getSecret())).compact();
    }
}

