/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.swaggerconf;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SwaggerConf {
    private SecurityScheme createAPIKeyScheme() {
        return new SecurityScheme().type(SecurityScheme.Type.HTTP).bearerFormat("JWT").scheme("bearer");
    }

    @Bean
    public OpenAPI openAPI() {
        return new OpenAPI().addSecurityItem(new SecurityRequirement().addList("Bearer Authentication")).components(new Components().addSecuritySchemes("Bearer Authentication", this.createAPIKeyScheme())).info(new Info().title("ValuationControl API").description("A rest API to create valuation models").version("1.0").contact(new Contact().name("Dartagnan Corporate Finance AS").email("support@valuationcontrol.app").url("https://www.valuationcontrol.app")).license(new License().name("License of API").url("API license URL")));
    }
}

