/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.xlhandler;

import app.valuationcontrol.webservice.xlhandler.GenericSheet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.formula.eval.NotImplementedException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class POISheet
implements GenericSheet {
    private static final Logger log = LogManager.getLogger(POISheet.class);
    private final String name;
    private final XSSFSheet sheet;

    public POISheet(String name, XSSFSheet sheet) {
        this.name = name;
        this.sheet = sheet;
    }

    public String getName() {
        return this.name;
    }

    public void setFormula(String formula, int column, int row) {
        XSSFRow xssfRow = this.sheet.getRow(row);
        if (xssfRow == null) {
            xssfRow = this.sheet.createRow(row);
        }
        XSSFCell cell = (XSSFCell)CellUtil.getCell((Row)xssfRow, (int)column);
        if (formula == null || formula.isBlank()) {
            cell.removeFormula();
            cell.setBlank();
        } else if (formula.startsWith("=")) {
            formula = formula.replaceFirst("=", "");
            formula = formula.replace(";", ",");
            try {
                cell.setCellFormula(formula);
            }
            catch (FormulaParseException e) {
                log.debug("Couldn't parse " + String.valueOf((Object)e) + " due to " + e.getMessage());
                cell.removeFormula();
                cell.setCellErrorValue(FormulaError.NA);
                XSSFCreationHelper creationHelper = this.sheet.getWorkbook().getCreationHelper();
                XSSFComment comment = this.sheet.createDrawingPatriarch().createCellComment(creationHelper.createClientAnchor());
                comment.setString(creationHelper.createRichTextString(e.getMessage()));
                comment.setAuthor("Autogenerated comment from ValuationControl");
                cell.setCellComment((Comment)comment);
            }
        } else {
            try {
                double d = Double.parseDouble(formula);
                cell.removeFormula();
                cell.setCellValue(d);
            }
            catch (NumberFormatException nfe) {
                cell.removeFormula();
                cell.setCellValue(formula);
            }
        }
    }

    public void setCellValues(GenericSheet.CellValue ... cellValues) {
        for (GenericSheet.CellValue cellValue : cellValues) {
            this.setFormula(Double.toString(cellValue.value()), cellValue.column(), cellValue.row());
        }
    }

    public void computeCellValues(GenericSheet.CellValue ... cellValues) {
        for (GenericSheet.CellValue cellValue : cellValues) {
            this.computeCell(cellValue.column(), cellValue.column());
        }
    }

    public void setValue(String[][] values, int columns, int rows) {
        for (int i = 0; i <= rows; ++i) {
            for (int j = 0; j <= columns; ++j) {
                this.setFormula(values[i][j], j, i);
            }
        }
    }

    public XSSFCell customGetCell(int column, int row) {
        XSSFRow xssfRow = this.sheet.getRow(row);
        if (xssfRow == null) {
            xssfRow = this.sheet.createRow(row);
        }
        return (XSSFCell)CellUtil.getCell((Row)xssfRow, (int)column);
    }

    public void computeCalculations() {
        try {
            XSSFFormulaEvaluator xssfFormulaEvaluator = new XSSFFormulaEvaluator(this.sheet.getWorkbook());
            xssfFormulaEvaluator.evaluateAll();
        }
        catch (NotImplementedException e) {
            log.info((Object)e);
        }
    }

    public void computeCell(int column, int row) {
        try {
            XSSFCell xssfCell = this.customGetCell(column, row);
            XSSFFormulaEvaluator xssfFormulaEvaluator = new XSSFFormulaEvaluator(this.sheet.getWorkbook());
            xssfFormulaEvaluator.evaluateFormulaCell((Cell)xssfCell);
        }
        catch (NotImplementedException e) {
            log.info((Object)e);
        }
    }

    public double getValue(int column, int row) {
        this.computeCalculations();
        return this.getValueWithoutRecalculation(column, row);
    }

    public double getValueWithoutRecalculation(int column, int row) {
        double returnValue = -99999.0;
        try {
            returnValue = this.customGetCell(column, row).getNumericCellValue();
        }
        catch (IllegalStateException e) {
            log.debug("Couldn't get a numerical value for cell {},{} in {}", (Object)column, (Object)row, (Object)this.name);
        }
        return returnValue;
    }

    public Object getCellContent(int column, int row) {
        Object cellValue;
        XSSFCell cell = this.customGetCell(column, row);
        try {
            cellValue = cell.getRawValue() == null ? "" : Double.valueOf(cell.getNumericCellValue());
        }
        catch (IllegalStateException | NotImplementedException e) {
            cellValue = cell.getRawValue();
        }
        return cellValue;
    }

    public Object[][] getValues(int endColumn, int endRow) {
        try {
            XSSFFormulaEvaluator xssfFormulaEvaluator = new XSSFFormulaEvaluator(this.sheet.getWorkbook());
            xssfFormulaEvaluator.evaluateAll();
        }
        catch (NotImplementedException e) {
            log.info((Object)e);
            log.info(e.getMessage());
            log.info((Object)e.getCause());
        }
        Object[][] returnObject = new Object[endRow + 1][endColumn + 1];
        for (int i = 0; i <= endRow; ++i) {
            for (int j = 0; j <= endColumn; ++j) {
                returnObject[i][j] = this.getCellContent(j, i);
            }
        }
        return returnObject;
    }

    public String getErrorInCell(int column, int row) {
        String error = null;
        XSSFCell cell = this.customGetCell(column, row);
        if (cell.getCellComment() != null) {
            error = cell.getCellComment().getString().toString();
        }
        return error;
    }

    public void setRowValues(int row, String[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.setFormula(data[i], i, row);
        }
    }
}

