/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.xlhandler;

import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.sensitivity.Sensitivity;
import app.valuationcontrol.webservice.model.sensitivity.SensitivityResult;
import app.valuationcontrol.webservice.model.variable.Variable;
import app.valuationcontrol.webservice.xlhandler.CalcDocument;
import app.valuationcontrol.webservice.xlhandler.GenericSheet;
import app.valuationcontrol.webservice.xlhandler.POICalcDocument;
import app.valuationcontrol.webservice.xlhandler.SCENARIO;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record SensitivityRunner(CalcDocument calcDocument, List<Sensitivity> sensitivities, SCENARIO scenario, Model model) {
    private final CalcDocument calcDocument;
    private final List<Sensitivity> sensitivities;
    private final SCENARIO scenario;
    private final Model model;
    private static final Logger log = LogManager.getLogger(SensitivityRunner.class);
    static final String SENSITIVITY_SHEET = POICalcDocument.getScenarioSheetName((SCENARIO)SCENARIO.SENSITIVITY);

    public SensitivityRunner(CalcDocument calcDocument, List<Sensitivity> sensitivities, SCENARIO scenario, Model model) {
        this.calcDocument = calcDocument;
        this.sensitivities = sensitivities;
        this.scenario = scenario;
        this.model = model;
    }

    public List<SensitivityResult> runSensitivities() {
        ArrayList<SensitivityResult> sensitivityResults = new ArrayList<SensitivityResult>();
        for (Sensitivity sensitivity : this.sensitivities) {
            log.info("Running sentivity " + sensitivity.getSensitivityName() + "for scenario  " + String.valueOf(this.scenario));
            Optional variable1 = this.model.getVariableWithID(sensitivity.getSensitivityVariable1Id().longValue());
            Optional variable2 = this.model.getVariableWithID(sensitivity.getSensitivityVariable2Id().longValue());
            Optional measurementVariable = this.model.getVariableWithID(sensitivity.getSensitivityMeasurementVariableId().longValue());
            if (variable1.isEmpty() || variable2.isEmpty() || measurementVariable.isEmpty()) {
                throw new IllegalArgumentException("One of the variables is not set");
            }
            double[] originalVariable1Value = new double[((Variable)variable1.get()).isModelledAtSegment() ? Math.max(1, this.model.getSegments().size()) : 1];
            double[] originalVariable2Value = new double[((Variable)variable2.get()).isModelledAtSegment() ? Math.max(1, this.model.getSegments().size()) : 1];
            double[] originalMeasurementValue = new double[((Variable)measurementVariable.get()).isModelledAtSegment() ? Math.max(1, this.model.getSegments().size() + 1) : 1];
            int column = 0;
            try {
                int k;
                GenericSheet scenarioGenericSheet = this.calcDocument.getSheet(this.scenario);
                GenericSheet sensitivityGenericSheet = this.calcDocument.copy(scenarioGenericSheet, SENSITIVITY_SHEET);
                int numberOfMeasurementSegments = ((Variable)measurementVariable.get()).isModelledAtSegment() ? Math.max(1, this.model.getSegments().size() + 1) : 1;
                SensitivityResult sensitivityResult = new SensitivityResult(sensitivity.getId(), Integer.valueOf(this.scenario.ordinal()), sensitivity.getSensitivityVariable1Steps(), sensitivity.getSensitivityVariable2Steps(), Integer.valueOf(numberOfMeasurementSegments));
                if (((Variable)variable1.get()).isModelledAtSegment() && !this.model.getSegments().isEmpty()) {
                    for (k = 0; k < this.model.getSegments().size(); ++k) {
                        originalVariable1Value[k] = this.getValueForVariableAtPeriod((Variable)variable1.get(), ((Variable)variable1.get()).columnOfSegmentAndPeriod(k, sensitivity.getSensitivityVariable1Period()), sensitivityGenericSheet, false);
                    }
                } else {
                    originalVariable1Value[0] = this.getValueForVariableAtPeriod((Variable)variable1.get(), ((Variable)variable1.get()).columnOfSegmentAndPeriod(-1, sensitivity.getSensitivityVariable1Period()), sensitivityGenericSheet, false);
                }
                if (((Variable)variable2.get()).isModelledAtSegment() && !this.model.getSegments().isEmpty()) {
                    for (k = 0; k < this.model.getSegments().size(); ++k) {
                        originalVariable2Value[k] = this.getValueForVariableAtPeriod((Variable)variable2.get(), ((Variable)variable2.get()).columnOfSegmentAndPeriod(k, sensitivity.getSensitivityVariable2Period()), sensitivityGenericSheet, false);
                    }
                } else {
                    originalVariable2Value[0] = this.getValueForVariableAtPeriod((Variable)variable2.get(), ((Variable)variable2.get()).columnOfSegmentAndPeriod(-1, sensitivity.getSensitivityVariable2Period()), sensitivityGenericSheet, false);
                }
                if (((Variable)measurementVariable.get()).isModelledAtSegment() && !this.model.getSegments().isEmpty()) {
                    for (k = 0; k <= this.model.getSegments().size(); ++k) {
                        int segmentIndex = k - 1;
                        originalMeasurementValue[k] = this.getValueForVariableAtPeriod((Variable)measurementVariable.get(), ((Variable)measurementVariable.get()).columnOfSegmentAndPeriod(segmentIndex, sensitivity.getSensitivityMeasurementVariablePeriod()), sensitivityGenericSheet, false);
                    }
                } else {
                    originalMeasurementValue[0] = this.getValueForVariableAtPeriod((Variable)measurementVariable.get(), ((Variable)measurementVariable.get()).columnOfSegmentAndPeriod(-1, sensitivity.getSensitivityMeasurementVariablePeriod()), sensitivityGenericSheet, false);
                }
                int variable1Offset = sensitivity.getSensitivityVariable1Steps() / 2;
                int variable2Offset = sensitivity.getSensitivityVariable2Steps() / 2;
                for (int h = 0; h < numberOfMeasurementSegments; ++h) {
                    log.debug("Original value: {} from column: {} from row: {} ", (Object)originalMeasurementValue[h], (Object)column, (Object)((Variable)measurementVariable.get()).getRow());
                    for (int i = 0; i < sensitivity.getSensitivityVariable1Steps(); ++i) {
                        double variable1Value = (float)(i - variable1Offset) * sensitivity.getSensitivityVariable1StepSize().floatValue();
                        if (!((Variable)variable1.get()).isModelledAtSegment() || this.model.getSegments().isEmpty()) {
                            variable1Value = originalVariable1Value[0] + (double)((float)(i - variable1Offset) * sensitivity.getSensitivityVariable1StepSize().floatValue());
                        }
                        sensitivityResult.setVariable1Values(i, Double.valueOf(variable1Value));
                        for (int j = 0; j < sensitivity.getSensitivityVariable2Steps(); ++j) {
                            int k2;
                            ArrayList<GenericSheet.CellValue> cellsToBeUpdated = new ArrayList<GenericSheet.CellValue>();
                            double variable2Value = (float)(j - variable2Offset) * sensitivity.getSensitivityVariable2StepSize().floatValue();
                            if (!((Variable)variable2.get()).isModelledAtSegment() || this.model.getSegments().isEmpty()) {
                                variable2Value = originalVariable2Value[0] + (double)((float)(j - variable2Offset) * sensitivity.getSensitivityVariable2StepSize().floatValue());
                            }
                            if (i == 0) {
                                sensitivityResult.setVariable2Values(j, Double.valueOf(variable2Value));
                            }
                            if (((Variable)variable1.get()).isModelledAtSegment() && !this.model.getSegments().isEmpty()) {
                                for (k2 = 0; k2 < this.model.getSegments().size(); ++k2) {
                                    variable1Value = originalVariable1Value[k2] + (double)((float)(i - variable1Offset) * sensitivity.getSensitivityVariable1StepSize().floatValue());
                                    cellsToBeUpdated.add(new GenericSheet.CellValue(variable1Value, ((Variable)variable1.get()).columnOfSegmentAndPeriod(k2, sensitivity.getSensitivityVariable1Period()), ((Variable)variable1.get()).getRow()));
                                }
                            } else {
                                cellsToBeUpdated.add(new GenericSheet.CellValue(variable1Value, ((Variable)variable1.get()).columnOfSegmentAndPeriod(-1, sensitivity.getSensitivityVariable1Period()), ((Variable)variable1.get()).getRow()));
                            }
                            if (((Variable)variable2.get()).isModelledAtSegment() && !this.model.getSegments().isEmpty()) {
                                for (k2 = 0; k2 < this.model.getSegments().size(); ++k2) {
                                    variable2Value = originalVariable2Value[k2] + (double)((float)(j - variable2Offset) * sensitivity.getSensitivityVariable2StepSize().floatValue());
                                    cellsToBeUpdated.add(new GenericSheet.CellValue(variable2Value, ((Variable)variable2.get()).columnOfSegmentAndPeriod(k2, sensitivity.getSensitivityVariable2Period()), ((Variable)variable2.get()).getRow()));
                                }
                            } else {
                                cellsToBeUpdated.add(new GenericSheet.CellValue(variable2Value, ((Variable)variable2.get()).columnOfSegmentAndPeriod(-1, sensitivity.getSensitivityVariable2Period()), ((Variable)variable2.get()).getRow()));
                            }
                            GenericSheet.CellValue[] cellsToBeUpdatedArray = new GenericSheet.CellValue[cellsToBeUpdated.size()];
                            cellsToBeUpdatedArray = cellsToBeUpdated.toArray(cellsToBeUpdatedArray);
                            sensitivityGenericSheet.setCellValues(cellsToBeUpdatedArray);
                            sensitivityGenericSheet.computeCellValues(cellsToBeUpdatedArray);
                            double measuredValue = this.getValueForVariableAtPeriod((Variable)measurementVariable.get(), ((Variable)measurementVariable.get()).columnOfSegmentAndPeriod(h - 1, sensitivity.getSensitivityMeasurementVariablePeriod()), sensitivityGenericSheet, true);
                            sensitivityResult.setMyResultArray(h, i, j, measuredValue);
                        }
                    }
                }
                sensitivityResult.setValid(true);
                sensitivityResults.add(sensitivityResult);
                this.calcDocument.remove(sensitivityGenericSheet);
            }
            catch (Exception e) {
                log.error("Error when running sensitivity", (Throwable)e);
            }
        }
        return sensitivityResults;
    }

    private double getValueForVariableAtPeriod(Variable variable, int column, GenericSheet genericSheet, boolean computeCell) {
        if (computeCell) {
            genericSheet.computeCell(column, variable.getRow());
        }
        return genericSheet.getValueWithoutRecalculation(column, variable.getRow());
    }

    public CalcDocument calcDocument() {
        return this.calcDocument;
    }

    public List<Sensitivity> sensitivities() {
        return this.sensitivities;
    }

    public SCENARIO scenario() {
        return this.scenario;
    }

    public Model model() {
        return this.model;
    }
}

