/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.enin;

import app.valuationcontrol.webservice.enin.EninAPIService;
import app.valuationcontrol.webservice.enin.records.CompanyNameRecord;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EninController {
    private static final Logger log = LogManager.getLogger(EninController.class);
    private final EninAPIService eninAPIService;

    public EninController(EninAPIService eninAPIService) {
        this.eninAPIService = eninAPIService;
    }

    @Operation(summary="This method is used to search for existing compnies")
    @GetMapping(value={"/api/searchcompany"})
    public ResponseEntity<CompanyNameRecord[]> searchEninForCompanies(@Parameter(description="the name of the company to be found") @RequestParam String companyName) {
        return ResponseEntity.ok((Object)this.eninAPIService.getCompanies(companyName));
    }
}

