/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.helpers;

import app.valuationcontrol.webservice.helpers.CellError;
import app.valuationcontrol.webservice.helpers.EntityDTOConverter;
import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.ModelData;
import app.valuationcontrol.webservice.model.area.AreaData;
import app.valuationcontrol.webservice.model.graph.ModelGraphData;
import app.valuationcontrol.webservice.model.segment.SegmentData;
import app.valuationcontrol.webservice.model.sensitivity.SensitivityData;
import app.valuationcontrol.webservice.model.sensitivity.SensitivityResult;
import app.valuationcontrol.webservice.model.variable.VariableData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CalculationData {
    private ModelData model;
    private List<SegmentData> segments = new ArrayList<SegmentData>();
    private List<AreaData> areas = new ArrayList<AreaData>();
    private List<ModelGraphData> graphs = new ArrayList<ModelGraphData>();
    private List<VariableData> variables = new ArrayList<VariableData>();
    private List<SensitivityData> sensitivities = new ArrayList<SensitivityData>();
    private Map<Long, List<CellError>> formulaErrors;
    private Map<Long, List<CellError>> variableCellErrors;
    private List<SensitivityResult> sensitivityResults = new ArrayList<SensitivityResult>();
    private int scenarioNumber = 0;

    public CalculationData() {
    }

    public CalculationData(Model model, List<SensitivityResult> sensitivityResults, Map<Long, List<CellError>> formulaErrors, Map<Long, List<CellError>> variableCellErrors, int scenarioNumber) {
        this.model = (ModelData)EntityDTOConverter.asData(model);
        this.segments = EntityDTOConverter.asData(model.getSegments());
        this.areas = EntityDTOConverter.asData(model.getAreas());
        this.graphs = EntityDTOConverter.asData(model.getGraphs());
        this.sensitivities = EntityDTOConverter.asData(model.getSensitivities());
        this.variables = EntityDTOConverter.asData(model.getVariables().stream().sorted((o1, o2) -> {
            if (Objects.equals(o1.getVariableAreaId(), o2.getVariableAreaId())) {
                if (Objects.equals(o1.getVariableSubAreaId(), o2.getVariableSubAreaId())) {
                    return o1.getVariableOrder().compareTo(o2.getVariableOrder());
                }
                return o1.getVariableSubArea().getSubAreaOrder().compareTo(o2.getVariableSubArea().getSubAreaOrder());
            }
            return o1.getVariableArea().getAreaOrder().compareTo(o2.getVariableArea().getAreaOrder());
        }).toList());
        this.variableCellErrors = variableCellErrors;
        this.sensitivityResults = sensitivityResults;
        this.formulaErrors = formulaErrors;
        this.scenarioNumber = scenarioNumber;
    }

    public ModelData getModel() {
        return this.model;
    }

    public List<SegmentData> getSegments() {
        return this.segments;
    }

    public List<AreaData> getAreas() {
        return this.areas;
    }

    public List<ModelGraphData> getGraphs() {
        return this.graphs;
    }

    public List<VariableData> getVariables() {
        return this.variables;
    }

    public List<SensitivityData> getSensitivities() {
        return this.sensitivities;
    }

    public Map<Long, List<CellError>> getFormulaErrors() {
        return this.formulaErrors;
    }

    public Map<Long, List<CellError>> getVariableCellErrors() {
        return this.variableCellErrors;
    }

    public List<SensitivityResult> getSensitivityResults() {
        return this.sensitivityResults;
    }

    public int getScenarioNumber() {
        return this.scenarioNumber;
    }

    public void setModel(ModelData model) {
        this.model = model;
    }

    public void setSegments(List<SegmentData> segments) {
        this.segments = segments;
    }

    public void setAreas(List<AreaData> areas) {
        this.areas = areas;
    }

    public void setGraphs(List<ModelGraphData> graphs) {
        this.graphs = graphs;
    }

    public void setVariables(List<VariableData> variables) {
        this.variables = variables;
    }

    public void setSensitivities(List<SensitivityData> sensitivities) {
        this.sensitivities = sensitivities;
    }

    public void setFormulaErrors(Map<Long, List<CellError>> formulaErrors) {
        this.formulaErrors = formulaErrors;
    }

    public void setVariableCellErrors(Map<Long, List<CellError>> variableCellErrors) {
        this.variableCellErrors = variableCellErrors;
    }

    public void setSensitivityResults(List<SensitivityResult> sensitivityResults) {
        this.sensitivityResults = sensitivityResults;
    }

    public void setScenarioNumber(int scenarioNumber) {
        this.scenarioNumber = scenarioNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculationData)) {
            return false;
        }
        CalculationData other = (CalculationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getScenarioNumber() != other.getScenarioNumber()) {
            return false;
        }
        ModelData this$model = this.getModel();
        ModelData other$model = other.getModel();
        if (this$model == null ? other$model != null : !((Object)this$model).equals(other$model)) {
            return false;
        }
        List<SegmentData> this$segments = this.getSegments();
        List<SegmentData> other$segments = other.getSegments();
        if (this$segments == null ? other$segments != null : !((Object)this$segments).equals(other$segments)) {
            return false;
        }
        List<AreaData> this$areas = this.getAreas();
        List<AreaData> other$areas = other.getAreas();
        if (this$areas == null ? other$areas != null : !((Object)this$areas).equals(other$areas)) {
            return false;
        }
        List<ModelGraphData> this$graphs = this.getGraphs();
        List<ModelGraphData> other$graphs = other.getGraphs();
        if (this$graphs == null ? other$graphs != null : !((Object)this$graphs).equals(other$graphs)) {
            return false;
        }
        List<VariableData> this$variables = this.getVariables();
        List<VariableData> other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        List<SensitivityData> this$sensitivities = this.getSensitivities();
        List<SensitivityData> other$sensitivities = other.getSensitivities();
        if (this$sensitivities == null ? other$sensitivities != null : !((Object)this$sensitivities).equals(other$sensitivities)) {
            return false;
        }
        Map<Long, List<CellError>> this$formulaErrors = this.getFormulaErrors();
        Map<Long, List<CellError>> other$formulaErrors = other.getFormulaErrors();
        if (this$formulaErrors == null ? other$formulaErrors != null : !((Object)this$formulaErrors).equals(other$formulaErrors)) {
            return false;
        }
        Map<Long, List<CellError>> this$variableCellErrors = this.getVariableCellErrors();
        Map<Long, List<CellError>> other$variableCellErrors = other.getVariableCellErrors();
        if (this$variableCellErrors == null ? other$variableCellErrors != null : !((Object)this$variableCellErrors).equals(other$variableCellErrors)) {
            return false;
        }
        List<SensitivityResult> this$sensitivityResults = this.getSensitivityResults();
        List<SensitivityResult> other$sensitivityResults = other.getSensitivityResults();
        return !(this$sensitivityResults == null ? other$sensitivityResults != null : !((Object)this$sensitivityResults).equals(other$sensitivityResults));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CalculationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getScenarioNumber();
        ModelData $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : ((Object)$model).hashCode());
        List<SegmentData> $segments = this.getSegments();
        result = result * 59 + ($segments == null ? 43 : ((Object)$segments).hashCode());
        List<AreaData> $areas = this.getAreas();
        result = result * 59 + ($areas == null ? 43 : ((Object)$areas).hashCode());
        List<ModelGraphData> $graphs = this.getGraphs();
        result = result * 59 + ($graphs == null ? 43 : ((Object)$graphs).hashCode());
        List<VariableData> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        List<SensitivityData> $sensitivities = this.getSensitivities();
        result = result * 59 + ($sensitivities == null ? 43 : ((Object)$sensitivities).hashCode());
        Map<Long, List<CellError>> $formulaErrors = this.getFormulaErrors();
        result = result * 59 + ($formulaErrors == null ? 43 : ((Object)$formulaErrors).hashCode());
        Map<Long, List<CellError>> $variableCellErrors = this.getVariableCellErrors();
        result = result * 59 + ($variableCellErrors == null ? 43 : ((Object)$variableCellErrors).hashCode());
        List<SensitivityResult> $sensitivityResults = this.getSensitivityResults();
        result = result * 59 + ($sensitivityResults == null ? 43 : ((Object)$sensitivityResults).hashCode());
        return result;
    }

    public String toString() {
        return "CalculationData(model=" + String.valueOf(this.getModel()) + ", segments=" + String.valueOf(this.getSegments()) + ", areas=" + String.valueOf(this.getAreas()) + ", graphs=" + String.valueOf(this.getGraphs()) + ", variables=" + String.valueOf(this.getVariables()) + ", sensitivities=" + String.valueOf(this.getSensitivities()) + ", formulaErrors=" + String.valueOf(this.getFormulaErrors()) + ", variableCellErrors=" + String.valueOf(this.getVariableCellErrors()) + ", sensitivityResults=" + String.valueOf(this.getSensitivityResults()) + ", scenarioNumber=" + this.getScenarioNumber() + ")";
    }
}

