/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.helpers;

import app.valuationcontrol.webservice.helpers.MyCustomFloatEditor;
import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.events.listeners.VariableNameChangeListener;
import app.valuationcontrol.webservice.model.variable.Variable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;

public abstract class FormulaEvaluator {
    private static final String LEFT_CURLY = "{";
    private static final String RIGHT_CURLY = "}";
    private static final Comparator<Variable> VARIABLE_NAME_LENGTH = (variable1, variable2) -> variable2.getVariableName().length() - variable1.getVariableName().length();
    public static final String PERCENTAGE = "_percentage_";
    public static final String PERCENTAGE_SIGN = "%";

    private FormulaEvaluator() {
    }

    public static String evaluateVariableFormula(Variable variable) {
        String currentEvaluatedFormula = variable.getVariableFormula().toLowerCase();
        currentEvaluatedFormula = currentEvaluatedFormula.trim();
        variable.getVariableDependencies().clear();
        try {
            MyCustomFloatEditor myCustomFloatEditor22 = new MyCustomFloatEditor(Float.class, false);
            myCustomFloatEditor22.setAsText(currentEvaluatedFormula);
            return currentEvaluatedFormula;
        }
        catch (NumberFormatException myCustomFloatEditor22) {
            try {
                Double.parseDouble(currentEvaluatedFormula);
                return currentEvaluatedFormula;
            }
            catch (NumberFormatException myCustomFloatEditor22) {
                try {
                    Integer.parseInt(currentEvaluatedFormula);
                    return currentEvaluatedFormula;
                }
                catch (NumberFormatException myCustomFloatEditor22) {
                    Model model = variable.getAttachedModel();
                    currentEvaluatedFormula = FormulaEvaluator.getCleanName(currentEvaluatedFormula);
                    ArrayList<Variable> myVariables = new ArrayList<Variable>(model.getVariables());
                    myVariables.sort(VARIABLE_NAME_LENGTH);
                    for (Variable searchVariable : myVariables) {
                        String replacement;
                        String cleanVariableName = FormulaEvaluator.getCleanName(searchVariable.getVariableName().toLowerCase(Locale.ROOT));
                        String matchStringClean = VariableNameChangeListener.exactWord(cleanVariableName);
                        if (!(currentEvaluatedFormula = currentEvaluatedFormula.replaceAll(matchStringClean, replacement = LEFT_CURLY + searchVariable.getId() + RIGHT_CURLY)).contains(replacement)) continue;
                        variable.addDependency(searchVariable);
                    }
                    return currentEvaluatedFormula.replace(PERCENTAGE, PERCENTAGE_SIGN);
                }
            }
        }
    }

    private static String getCleanName(String name) {
        return name.replace(PERCENTAGE_SIGN, PERCENTAGE).replace("'", "").toLowerCase();
    }
}

