/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model;

import app.valuationcontrol.webservice.helpers.CalculationData;
import app.valuationcontrol.webservice.helpers.exceptions.ResourceException;
import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.ModelRepository;
import app.valuationcontrol.webservice.user.UserRepository;
import app.valuationcontrol.webservice.xlhandler.SCENARIO;
import app.valuationcontrol.webservice.xlhandler.XLHandleManager;
import jakarta.transaction.Transactional;
import java.security.Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.messaging.handler.annotation.DestinationVariable;
import org.springframework.messaging.handler.annotation.MessageExceptionHandler;
import org.springframework.messaging.simp.annotation.SendToUser;
import org.springframework.messaging.simp.annotation.SubscribeMapping;
import org.springframework.stereotype.Controller;
import org.springframework.web.server.ResponseStatusException;

@Controller
public class SubscribeController {
    private static final Logger log = LogManager.getLogger(SubscribeController.class);
    private final XLHandleManager handleManager;
    private final ModelRepository modelRepository;
    private final UserRepository userRepository;

    @Autowired
    public SubscribeController(XLHandleManager handleManager, ModelRepository modelRepository, UserRepository userRepository) {
        this.handleManager = handleManager;
        this.modelRepository = modelRepository;
        this.userRepository = userRepository;
    }

    @MessageExceptionHandler
    @SendToUser(value={"/topic/errors"})
    public String handleExceptions(ResponseStatusException responseStatusException) {
        log.info("SENDING EXCEPTION TO USER");
        return responseStatusException.getReason();
    }

    @SubscribeMapping(value={"/topic/model/{modelId}/{scenario}"})
    @Transactional
    public CalculationData subscribingToModel(@DestinationVariable(value="modelId") Long modelId, @DestinationVariable(value="scenario") int scenario, Principal principal) throws ResponseStatusException {
        try {
            this.checkAccess(principal, modelId);
            return this.modelRepository.findById(modelId).map(model -> {
                log.debug("Preparing data to websocket");
                CalculationData returnData = this.handleManager.getXLInstanceForModel((Model)model).getContent(SCENARIO.from(scenario));
                log.debug("Sending data to websocket");
                return returnData;
            }).orElse(null);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e);
            throw new ResourceException(HttpStatus.BAD_REQUEST, "Wrong scenarioNumber");
        }
    }

    @SubscribeMapping(value={"/topic/changelog/{modelId}"})
    @Transactional
    public void subscribingToChangeLog(@DestinationVariable(value="modelId") Long modelId, Principal principal) {
        this.assertAccessAndRun(modelId, principal, () -> {});
        log.debug(principal.getName() + " subscribed to changelog :" + modelId);
    }

    private void checkAccess(Principal principal, Long modelId) throws ResponseStatusException {
        Model model = (Model)this.modelRepository.findById(modelId).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Couldn't find the requested model"));
        this.userRepository.findByModel(model).stream().filter(user -> user.getEmail().equalsIgnoreCase(principal.getName())).findFirst().orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "You do not have access to this model"));
    }

    private void assertAccessAndRun(Long modelId, Principal principal, Runnable action) {
        this.checkAccess(principal, modelId);
        action.run();
    }
}

