/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.area;

import app.valuationcontrol.webservice.EntityService;
import app.valuationcontrol.webservice.helpers.ModelChecker;
import app.valuationcontrol.webservice.helpers.ModelProvider;
import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.area.Area;
import app.valuationcontrol.webservice.model.area.AreaData;
import app.valuationcontrol.webservice.model.events.Event;
import app.valuationcontrol.webservice.model.events.Events;
import app.valuationcontrol.webservice.model.events.listeners.AuditLog;
import jakarta.transaction.Transactional;
import jakarta.validation.Valid;
import java.security.Principal;
import java.util.Arrays;
import org.springframework.data.util.Pair;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
public class AreaController {
    private static final String SWAPPED_ORDER = "Changed order of zone %s and %s";
    private final AuditLog auditlog;
    private final EntityService entityService;
    private final Events events;

    public AreaController(AuditLog auditlog, EntityService entityService, Events events) {
        this.auditlog = auditlog;
        this.entityService = entityService;
        this.events = events;
    }

    @PostMapping(value={"/api/model/{modelId}/area"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#existingModel,'EDITOR')")
    public ResponseEntity<Long> createArea(@PathVariable(value="modelId") Model existingModel, @Valid @RequestBody AreaData area, Principal principal) {
        Area newArea = new Area(area, existingModel);
        existingModel.getAreas().add(newArea);
        this.entityService.safeCreate(Area.class, newArea, new ModelProvider[0]);
        Event<Area> areaEvent = Event.created(this, newArea, principal, Area.class, existingModel);
        this.events.publishCustomEvent(areaEvent);
        this.events.processEvents(principal);
        return new ResponseEntity((Object)newArea.getId(), (HttpStatusCode)HttpStatus.CREATED);
    }

    @PostMapping(value={"/api/model/{modelId}/swap/{areaId}/{newAreaId}"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<String> swapAreaOrder(@PathVariable(value="modelId") Model model, @PathVariable(value="areaId") Area area, @PathVariable(value="newAreaId") Area newArea, Principal principal) {
        Area oldArea = new Area(area);
        Area oldSecondArea = new Area(newArea);
        if (!ModelChecker.inSameModel(model, area, newArea)) {
            return ResponseEntity.badRequest().build();
        }
        int areaOrderBefore = area.getAreaOrder();
        area.setAreaOrder(newArea.getAreaOrder());
        newArea.setAreaOrder(areaOrderBefore);
        this.entityService.updateAll(Area.class, Arrays.asList(Pair.of((Object)oldArea, (Object)area), Pair.of((Object)oldSecondArea, (Object)newArea)));
        this.auditlog.log(area.getAttachedModel(), String.format(SWAPPED_ORDER, area.getAreaName(), newArea.getAreaName()), principal);
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"api/model/{modelId}/area/{areaId}"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<String> updateArea(@PathVariable(value="modelId") Model model, @PathVariable(value="areaId") Area existingArea, @Valid @RequestBody AreaData areaData, Principal principal) {
        Area oldArea = new Area(existingArea);
        existingArea.updateFrom(areaData);
        if (!ModelChecker.inSameModel(model, existingArea)) {
            return ResponseEntity.badRequest().build();
        }
        Event<Area> areaEvent = Event.updated(this, oldArea, existingArea, principal, Area.class, model);
        this.events.publishCustomEvent(areaEvent);
        this.events.processEvents(principal);
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"/api/model/{modelId}/area/{areaId}"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<String> deleteArea(@PathVariable(value="modelId") Model model, @PathVariable(value="areaId") Area area, Principal principal) {
        if (!ModelChecker.inSameModel(model, area)) {
            return ResponseEntity.badRequest().build();
        }
        if (!area.getSubAreas().isEmpty()) {
            return ResponseEntity.badRequest().body((Object)("This area cannot be deleted as there are " + area.getSubAreas().size() + " subareas in this area. Please remove them prior to removing this area."));
        }
        if (model.getVariables().stream().anyMatch(v -> v.getVariableAreaId().equals(area.getId()))) {
            return ResponseEntity.badRequest().body((Object)("This area cannot be deleted as there are " + model.getVariables().stream().filter(v -> v.getVariableAreaId().equals(area.getId())).count() + " variables in this area. Please remove them prior to removing this area."));
        }
        if (!model.getAreas().contains(area)) {
            return ResponseEntity.badRequest().body((Object)"This area cannot be found in this model");
        }
        model.getAreas().remove(area);
        Event<Area> areaEvent = Event.deleted(this, area, principal, Area.class, model);
        this.events.publishCustomEvent(areaEvent);
        this.events.processEvents(principal);
        return ResponseEntity.ok((Object)"Area was deleted correctly");
    }
}

