/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.events.listeners.logger;

import app.valuationcontrol.webservice.model.events.Event;
import app.valuationcontrol.webservice.model.events.listeners.AuditLog;
import app.valuationcontrol.webservice.model.graph.ModelGraph;
import app.valuationcontrol.webservice.model.logentry.LogEntryRepository;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class ModelGraphLogger {
    private final LogEntryRepository logEntryRepository;

    public ModelGraphLogger(LogEntryRepository logEntryRepository) {
        this.logEntryRepository = logEntryRepository;
    }

    @EventListener
    public void onEvent(Event<ModelGraph> event) {
        switch (event.getType()) {
            case CREATED: {
                AuditLog.log(this.logEntryRepository, event.getNewVersion().getAttachedModel(), "Created graph " + event.getNewVersion().getGraphName(), event.getPrincipal());
                break;
            }
            case DELETED: {
                AuditLog.log(this.logEntryRepository, event.getOldVersion().getAttachedModel(), "Deleted graph " + event.getOldVersion().getGraphName(), event.getPrincipal());
                break;
            }
            case UPDATED: 
            case METADATA_UPDATE: {
                AuditLog.log(this.logEntryRepository, event.getOldVersion().getAttachedModel(), "Updated graph " + event.getOldVersion().getGraphName(), event.getPrincipal());
            }
        }
    }
}

