/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.events.listeners.logger;

import app.valuationcontrol.webservice.model.events.Event;
import app.valuationcontrol.webservice.model.events.listeners.AuditLog;
import app.valuationcontrol.webservice.model.logentry.LogEntryRepository;
import app.valuationcontrol.webservice.model.segment.Segment;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class SegmentLogger {
    private final LogEntryRepository logEntryRepository;

    public SegmentLogger(LogEntryRepository logEntryRepository) {
        this.logEntryRepository = logEntryRepository;
    }

    @EventListener
    public void onEvent(Event<Segment> event) {
        switch (event.getType()) {
            case CREATED: {
                AuditLog.log(this.logEntryRepository, event.getNewVersion().getAttachedModel(), "Added segment " + event.getNewVersion().getSegmentName(), event.getPrincipal());
                break;
            }
            case DELETED: {
                AuditLog.log(this.logEntryRepository, event.getOldVersion().getAttachedModel(), "Removed segment " + event.getOldVersion().getSegmentName(), event.getPrincipal());
                break;
            }
            case UPDATED: 
            case METADATA_UPDATE: {
                AuditLog.log(this.logEntryRepository, event.getOldVersion().getAttachedModel(), "Updated segment " + event.getNewVersion().getSegmentName(), event.getPrincipal());
            }
        }
    }
}

