/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.events.listeners.logger;

import app.valuationcontrol.webservice.model.events.Event;
import app.valuationcontrol.webservice.model.events.listeners.AuditLog;
import app.valuationcontrol.webservice.model.logentry.LogEntryRepository;
import app.valuationcontrol.webservice.model.sensitivity.Sensitivity;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class SensitivityLogger {
    private final LogEntryRepository logEntryRepository;

    public SensitivityLogger(LogEntryRepository logEntryRepository) {
        this.logEntryRepository = logEntryRepository;
    }

    @EventListener
    public void onEvent(Event<Sensitivity> event) {
        switch (event.getType()) {
            case CREATED: {
                AuditLog.log(this.logEntryRepository, event.getNewVersion().getAttachedModel(), "Added sensitivity " + event.getNewVersion().getSensitivityName(), event.getPrincipal());
                break;
            }
            case DELETED: {
                AuditLog.log(this.logEntryRepository, event.getOldVersion().getAttachedModel(), "Removed sensitivity " + event.getOldVersion().getSensitivityName(), event.getPrincipal());
                break;
            }
            case UPDATED: 
            case METADATA_UPDATE: {
                AuditLog.log(this.logEntryRepository, event.getOldVersion().getAttachedModel(), "Updated sensitivity " + event.getNewVersion().getSensitivityName(), event.getPrincipal());
            }
        }
    }
}

