/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.events.listeners.logger;

import app.valuationcontrol.webservice.model.events.Event;
import app.valuationcontrol.webservice.model.events.listeners.AuditLog;
import app.valuationcontrol.webservice.model.logentry.LogEntryRepository;
import app.valuationcontrol.webservice.model.subarea.SubArea;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class SubAreaLogger {
    private static final String ADDED_SUBAREA = "Added subarea %s";
    private static final String UPDATED_SUBAREA = "Updated subarea %s";
    private static final String REMOVED_SUB_AREA = "Removed sub area %s";
    private final LogEntryRepository logEntryRepository;

    public SubAreaLogger(LogEntryRepository logEntryRepository) {
        this.logEntryRepository = logEntryRepository;
    }

    @EventListener
    public void onEvent(Event<SubArea> event) {
        switch (event.getType()) {
            case CREATED: {
                AuditLog.log(this.logEntryRepository, event.getNewVersion().getAttachedArea().getAttachedModel(), String.format(ADDED_SUBAREA, event.getNewVersion().getSubAreaName()), event.getPrincipal());
                break;
            }
            case DELETED: {
                AuditLog.log(this.logEntryRepository, event.getOldVersion().getAttachedArea().getAttachedModel(), String.format(REMOVED_SUB_AREA, event.getOldVersion().getSubAreaName()), event.getPrincipal());
                break;
            }
            case UPDATED: 
            case METADATA_UPDATE: {
                AuditLog.log(this.logEntryRepository, event.getOldVersion().getAttachedArea().getAttachedModel(), String.format(UPDATED_SUBAREA, event.getNewVersion().getSubAreaName()), event.getPrincipal());
            }
        }
    }
}

