/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.events.listeners.logger;

import app.valuationcontrol.webservice.model.events.Event;
import app.valuationcontrol.webservice.model.events.listeners.AuditLog;
import app.valuationcontrol.webservice.model.logentry.LogEntryRepository;
import app.valuationcontrol.webservice.model.variable.Variable;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class VariableLogger {
    private final LogEntryRepository logEntryRepository;

    public VariableLogger(LogEntryRepository logEntryRepository) {
        this.logEntryRepository = logEntryRepository;
    }

    @EventListener
    public void onEvent(Event<Variable> event) {
        switch (event.getType()) {
            case CREATED: {
                Variable entity = event.getNewVersion();
                AuditLog.log(this.logEntryRepository, entity.getAttachedModel(), "Create variable " + entity.getVariableType(), event.getPrincipal(), null, entity.getVariableFormula(), entity.getId());
                break;
            }
            case DELETED: {
                Variable entity = event.getOldVersion();
                AuditLog.log(this.logEntryRepository, entity.getAttachedModel(), "Deleted variable " + entity.getVariableName(), event.getPrincipal(), entity.getVariableFormula(), "", entity.getId());
                break;
            }
            case UPDATED: 
            case METADATA_UPDATE: {
                Variable oldVersion = event.getOldVersion();
                Variable newVersion = event.getNewVersion();
                AuditLog.log(this.logEntryRepository, oldVersion.getAttachedModel(), "Update variable " + oldVersion.getVariableName() + " ( " + newVersion.getVariableName() + ")", event.getPrincipal(), oldVersion.getVariableFormula(), newVersion.getVariableFormula(), newVersion.getId());
            }
        }
    }
}

