/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.events.listeners.logger;

import app.valuationcontrol.webservice.model.events.Event;
import app.valuationcontrol.webservice.model.logentry.LogEntry;
import app.valuationcontrol.webservice.model.logentry.LogEntryRepository;
import app.valuationcontrol.webservice.model.variablevalue.VariableValue;
import java.time.LocalDateTime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class VariableValueLogger {
    private static final Logger log = LogManager.getLogger(VariableValueLogger.class);
    private static final String ADDED_VARIABLE_VALUE_FOR = "Added variable value";
    private static final String REMOVED_VARIABLE_VALUE_FOR = "Removed variable value";
    private static final String UPDATED_VARIABLE_VALUE_FOR = "Updated variable value";
    private final LogEntryRepository logEntryRepository;

    public VariableValueLogger(LogEntryRepository logEntryRepository) {
        this.logEntryRepository = logEntryRepository;
    }

    @EventListener
    public void onEvent(Event<VariableValue> event) {
        VariableValue vv = event.effectedEntity();
        LogEntry.LogEntryBuilder logEntryBuilder = LogEntry.builder().username(event.getPrincipal().getName()).changeDate(LocalDateTime.now()).fromFormula("").toFormula("").variableId(vv.getAttachedVariable().getId()).attachedModel(vv.getAttachedVariable().getAttachedModel()).period(vv.getPeriod());
        switch (event.getType()) {
            case CREATED: {
                LogEntry entry = logEntryBuilder.fromValue(null).toValue(vv.getValue()).action(ADDED_VARIABLE_VALUE_FOR).build();
                this.logEntryRepository.save(entry);
                break;
            }
            case DELETED: {
                LogEntry entry = logEntryBuilder.action(REMOVED_VARIABLE_VALUE_FOR).fromValue(vv.getValue()).toValue(null).build();
                this.logEntryRepository.save(entry);
                break;
            }
            case UPDATED: 
            case METADATA_UPDATE: {
                LogEntry entry = logEntryBuilder.fromValue(event.getOldVersion().getValue()).toValue(event.getNewVersion().getValue()).action(UPDATED_VARIABLE_VALUE_FOR).build();
                this.logEntryRepository.save(entry);
            }
        }
    }
}

