/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.segment;

import app.valuationcontrol.webservice.helpers.DataTransformer;
import app.valuationcontrol.webservice.helpers.ModelProvider;
import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.segment.SegmentData;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"attached_model_id", "segment_name"})})
public class Segment
implements DataTransformer<SegmentData>,
ModelProvider {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @ManyToOne
    private Model attachedModel;
    @Column(name="segment_name")
    private String segmentName;
    @Column(name="segment_currency")
    private String segmentCurrency;

    public Segment() {
    }

    public Segment(Segment segment) {
        this(segment.asData(), segment.getAttachedModel());
    }

    public Segment(SegmentData segmentData, Model attachedModel) {
        this.updateFrom(segmentData, attachedModel);
    }

    @Override
    public SegmentData asData() {
        return new SegmentData(this.id, this.segmentName, this.segmentCurrency);
    }

    public void updateFrom(SegmentData segmentData, Model model) {
        this.attachedModel = model;
        this.segmentName = segmentData.segmentName();
        this.segmentCurrency = segmentData.segmentCurrency();
    }

    @Override
    public Long getModelId() {
        return this.attachedModel.getId();
    }

    public long getId() {
        return this.id;
    }

    public Model getAttachedModel() {
        return this.attachedModel;
    }

    public String getSegmentName() {
        return this.segmentName;
    }

    public String getSegmentCurrency() {
        return this.segmentCurrency;
    }

    public void setAttachedModel(Model attachedModel) {
        this.attachedModel = attachedModel;
    }

    public void setSegmentName(String segmentName) {
        this.segmentName = segmentName;
    }

    public void setSegmentCurrency(String segmentCurrency) {
        this.segmentCurrency = segmentCurrency;
    }
}

