/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.sensitivity;

import app.valuationcontrol.webservice.helpers.DataTransformer;
import app.valuationcontrol.webservice.helpers.ModelProvider;
import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.sensitivity.SensitivityData;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import java.time.LocalDateTime;

@Entity
public class Sensitivity
implements DataTransformer<SensitivityData>,
ModelProvider {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne
    private Model attachedModel;
    private String sensitivityName;
    private String sensitivityDescription;
    private Long sensitivityVariable1Id;
    private Long sensitivityVariable2Id;
    private Long sensitivityMeasurementVariableId;
    private Integer sensitivityVariable1Period;
    private Integer sensitivityVariable2Period;
    private Integer sensitivityMeasurementVariablePeriod;
    private Integer sensitivityVariable1Steps;
    private Integer sensitivityVariable2Steps;
    private Float sensitivityVariable1StepSize;
    private Float sensitivityVariable2StepSize;
    private LocalDateTime sensitivityLastRun;

    public Sensitivity(Sensitivity sensitivity) {
        this(sensitivity.asData(), sensitivity.getAttachedModel());
        this.id = sensitivity.id;
    }

    public Sensitivity(SensitivityData sensitivityData, Model model) {
        this.attachedModel = model;
        this.updateWith(sensitivityData);
    }

    public static Integer fromYear(Integer year, Model model) {
        if (year == null) {
            return null;
        }
        int yearIndex = year - model.getStartYear();
        if (yearIndex + model.getNbHistoricalPeriod() < 0 || yearIndex - model.getNbProjectionPeriod() > 0) {
            throw new IllegalArgumentException("Year: " + year + " is outside of the model (" + (model.getStartYear() - model.getNbHistoricalPeriod()) + " - " + (model.getStartYear() + model.getNbProjectionPeriod()) + ")");
        }
        return yearIndex;
    }

    public Sensitivity() {
    }

    @Override
    public SensitivityData asData() {
        return new SensitivityData(this.id, this.sensitivityName, this.sensitivityDescription, this.sensitivityVariable1Id, this.sensitivityVariable2Id, this.sensitivityMeasurementVariableId, Sensitivity.asModelYear(this.sensitivityVariable1Period, this.getAttachedModel()), Sensitivity.asModelYear(this.sensitivityVariable2Period, this.getAttachedModel()), Sensitivity.asModelYear(this.sensitivityMeasurementVariablePeriod, this.getAttachedModel()), this.sensitivityVariable1Steps, this.sensitivityVariable2Steps, this.sensitivityVariable1StepSize, this.sensitivityVariable2StepSize, this.sensitivityLastRun);
    }

    public static Integer asModelYear(Integer indexedPeriod, Model model) {
        if (indexedPeriod != null && indexedPeriod > model.getNbProjectionPeriod()) {
            return indexedPeriod;
        }
        return Sensitivity.asModelYear(indexedPeriod, model.getStartYear());
    }

    public static Integer asModelYear(Integer indexedPeriod, Integer startYear) {
        if (indexedPeriod == null) {
            return null;
        }
        return startYear + indexedPeriod;
    }

    @Override
    public Long getModelId() {
        return this.getAttachedModel().getId();
    }

    public void updateWith(SensitivityData sensitivityData) {
        this.sensitivityName = sensitivityData.name();
        this.sensitivityDescription = sensitivityData.description();
        this.sensitivityVariable1Id = sensitivityData.variable1Id();
        this.sensitivityVariable2Id = sensitivityData.variable2Id();
        this.sensitivityMeasurementVariableId = sensitivityData.measurementVariableId();
        this.sensitivityVariable1Period = Sensitivity.fromYear(sensitivityData.variable1Period(), this.attachedModel);
        this.sensitivityVariable2Period = Sensitivity.fromYear(sensitivityData.variable2Period(), this.attachedModel);
        this.sensitivityMeasurementVariablePeriod = Sensitivity.fromYear(sensitivityData.measurementVariablePeriod(), this.attachedModel);
        this.sensitivityVariable1Steps = sensitivityData.variable1Steps();
        this.sensitivityVariable2Steps = sensitivityData.variable2Steps();
        this.sensitivityVariable1StepSize = sensitivityData.variable1StepSize();
        this.sensitivityVariable2StepSize = sensitivityData.variable2StepSize();
    }

    public Long getId() {
        return this.id;
    }

    public Model getAttachedModel() {
        return this.attachedModel;
    }

    public String getSensitivityName() {
        return this.sensitivityName;
    }

    public String getSensitivityDescription() {
        return this.sensitivityDescription;
    }

    public Long getSensitivityVariable1Id() {
        return this.sensitivityVariable1Id;
    }

    public Long getSensitivityVariable2Id() {
        return this.sensitivityVariable2Id;
    }

    public Long getSensitivityMeasurementVariableId() {
        return this.sensitivityMeasurementVariableId;
    }

    public Integer getSensitivityVariable1Period() {
        return this.sensitivityVariable1Period;
    }

    public Integer getSensitivityVariable2Period() {
        return this.sensitivityVariable2Period;
    }

    public Integer getSensitivityMeasurementVariablePeriod() {
        return this.sensitivityMeasurementVariablePeriod;
    }

    public Integer getSensitivityVariable1Steps() {
        return this.sensitivityVariable1Steps;
    }

    public Integer getSensitivityVariable2Steps() {
        return this.sensitivityVariable2Steps;
    }

    public Float getSensitivityVariable1StepSize() {
        return this.sensitivityVariable1StepSize;
    }

    public Float getSensitivityVariable2StepSize() {
        return this.sensitivityVariable2StepSize;
    }

    public LocalDateTime getSensitivityLastRun() {
        return this.sensitivityLastRun;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setAttachedModel(Model attachedModel) {
        this.attachedModel = attachedModel;
    }

    public void setSensitivityVariable1Id(Long sensitivityVariable1Id) {
        this.sensitivityVariable1Id = sensitivityVariable1Id;
    }

    public void setSensitivityVariable2Id(Long sensitivityVariable2Id) {
        this.sensitivityVariable2Id = sensitivityVariable2Id;
    }

    public void setSensitivityMeasurementVariableId(Long sensitivityMeasurementVariableId) {
        this.sensitivityMeasurementVariableId = sensitivityMeasurementVariableId;
    }

    public void setSensitivityLastRun(LocalDateTime sensitivityLastRun) {
        this.sensitivityLastRun = sensitivityLastRun;
    }
}

