/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.subarea;

import app.valuationcontrol.webservice.helpers.DataTransformer;
import app.valuationcontrol.webservice.helpers.ModelProvider;
import app.valuationcontrol.webservice.model.area.Area;
import app.valuationcontrol.webservice.model.subarea.SubAreaData;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import java.util.OptionalInt;

@Entity
public class SubArea
implements DataTransformer<SubAreaData>,
ModelProvider {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @ManyToOne
    private Area attachedArea;
    private String subAreaName;
    private String subAreaDescription;
    private boolean modelledAtSegment;
    private Integer subAreaOrder;

    public SubArea() {
    }

    public SubArea(SubArea subArea) {
        this(subArea.asData(), subArea.getAttachedArea());
        this.setSubAreaOrder(subArea.getSubAreaOrder());
    }

    public SubArea(SubAreaData subAreaData, Area area) {
        this.updateWith(subAreaData, area);
    }

    private int nextSubAreaOrder(Area area) {
        OptionalInt max = area.getSubAreas().stream().mapToInt(SubArea::getSubAreaOrder).max();
        return max.orElse(0) + 1;
    }

    @Override
    public SubAreaData asData() {
        return new SubAreaData(this.id, this.subAreaName, this.subAreaDescription, this.modelledAtSegment, this.subAreaOrder, this.attachedArea.getId());
    }

    public void updateWith(SubAreaData subAreaData, Area area) {
        this.setSubAreaName(subAreaData.subAreaName());
        this.setSubAreaDescription(subAreaData.subAreaDescription());
        this.setModelledAtSegment(Boolean.TRUE.equals(subAreaData.modelledAtSegment()));
        this.setAttachedArea(area);
        if (area.getSubAreas().stream().anyMatch(subArea -> subArea.id == this.id)) {
            this.setSubAreaOrder(subAreaData.subAreaOrder());
        } else {
            this.setSubAreaOrder(this.nextSubAreaOrder(area));
        }
    }

    @Override
    public Long getModelId() {
        return this.attachedArea.getModelId();
    }

    public long getId() {
        return this.id;
    }

    public Area getAttachedArea() {
        return this.attachedArea;
    }

    public String getSubAreaName() {
        return this.subAreaName;
    }

    public String getSubAreaDescription() {
        return this.subAreaDescription;
    }

    public boolean isModelledAtSegment() {
        return this.modelledAtSegment;
    }

    public Integer getSubAreaOrder() {
        return this.subAreaOrder;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setAttachedArea(Area attachedArea) {
        this.attachedArea = attachedArea;
    }

    public void setSubAreaName(String subAreaName) {
        this.subAreaName = subAreaName;
    }

    public void setSubAreaDescription(String subAreaDescription) {
        this.subAreaDescription = subAreaDescription;
    }

    public void setModelledAtSegment(boolean modelledAtSegment) {
        this.modelledAtSegment = modelledAtSegment;
    }

    public void setSubAreaOrder(Integer subAreaOrder) {
        this.subAreaOrder = subAreaOrder;
    }
}

