/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.variable;

import app.valuationcontrol.webservice.EntityService;
import app.valuationcontrol.webservice.helpers.ModelChecker;
import app.valuationcontrol.webservice.helpers.exceptions.ResourceException;
import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.area.Area;
import app.valuationcontrol.webservice.model.events.Event;
import app.valuationcontrol.webservice.model.events.Events;
import app.valuationcontrol.webservice.model.subarea.SubArea;
import app.valuationcontrol.webservice.model.variable.Variable;
import app.valuationcontrol.webservice.model.variable.VariableData;
import app.valuationcontrol.webservice.model.variablevalue.ImportVariableValueData;
import app.valuationcontrol.webservice.model.variablevalue.VariableValue;
import app.valuationcontrol.webservice.model.variablevalue.VariableValueData;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
public class VariableController {
    private static final Logger log = LogManager.getLogger(VariableController.class);
    private final EntityService entityService;
    private final Events events;
    public static final String MODEL_ID_DESCRIPTION = "The id of the model containing the variable";
    public static final String VARIABLE_ID = "variableId";
    public static final String VARIABLE_ID_DESCRIPTION = "The id of the variable to be amended";
    public static final String VARIABLE_VALUE_ID = "variableValueId";
    public static final String VARIABLE_VALUE_ID_DESCRIPTION = "The id of the value to be amended";
    public static final String AREA_ID = "areaId";
    public static final String AREA_ID_DESCRIPTION = "The id of the area containing the variable";
    public static final String SUB_AREA_ID = "subAreaId";
    public static final String SUB_AREA_ID_DESCRIPTION = "The id of the sub-area containing the variable";

    public VariableController(EntityService entityService, Events events) {
        this.entityService = entityService;
        this.events = events;
    }

    @Operation(summary="Swap order of two variables", description="Use this entrypoint to swap the order of two variable in the model", responses={@ApiResponse(responseCode="200", description="Successfull operation"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @PostMapping(value={"/api/model/{modelId}/swapvariable/{variable1}/{variable2}"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<String> swapVariableOrder(@Parameter(description="The id of the model containing the variable", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model, @Parameter(description="The id of the first variable to be swapped", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="variable1") Variable variable1, @Parameter(description="The id of the second variable to be swapped", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="variable2") Variable variable2, Principal principal) {
        if (ModelChecker.inSameModel(variable1, variable2)) {
            Integer variable1Order = variable1.getVariableOrder();
            variable1.setVariableOrder(variable2.getVariableOrder());
            variable2.setVariableOrder(variable1Order);
            Event<Model> modelEvent = Event.lightUpdated(this, model, principal, Model.class, model);
            this.events.publishCustomEvent(modelEvent);
            this.events.processEvents(principal);
            return ResponseEntity.ok().build();
        }
        throw new ResourceException(HttpStatus.BAD_REQUEST, "Variables are not in the same model");
    }

    @Operation(summary="Create a new variable in the model", description="Use this entrypoint to add a variable to the model", responses={@ApiResponse(responseCode="201", description="the id of the created variable"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @PostMapping(value={"/api/model/{modelId}/area/{areaId}/subarea/{subAreaId}/variable"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<Long> createVariable(@Parameter(description="The id of the model containing the variable", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model, @Parameter(description="The id of the area containing the variable", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="areaId") Area area, @Parameter(description="The id of the sub-area containing the variable", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="subAreaId") SubArea subArea, @RequestBody @Valid VariableData variableData, Principal principal) {
        if (!ModelChecker.inSameModel(model, area, subArea)) {
            throw new ResourceException(HttpStatus.BAD_REQUEST, "Check the consistency of the request");
        }
        if (ModelChecker.isProtectedName(variableData.variableName())) {
            throw new ResourceException(HttpStatus.BAD_REQUEST, variableData.variableName() + " is a protected name (Excel function), please change the name of the variable");
        }
        Variable variable = new Variable(variableData, model, area, subArea);
        model.getVariables().add(variable);
        return this.entityService.safeCreate(Variable.class, variable, model, area, subArea).map(createVariable -> {
            Event<Variable> variableEvent = Event.created(this, createVariable, principal, Variable.class, model);
            this.events.publishCustomEvent(variableEvent);
            this.events.processEvents(principal);
            return new ResponseEntity((Object)createVariable.getId(), (HttpStatusCode)HttpStatus.CREATED);
        }).orElse(ResponseEntity.badRequest().build());
    }

    @Operation(summary="Update a variable", description="Use this entrypoint to update a variable to the model", responses={@ApiResponse(responseCode="200", description="Successfull operation"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @PutMapping(value={"/api/model/{modelId}/area/{areaId}/subarea/{subAreaId}/variable/{variableId}"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<String> updateVariable(@Parameter(description="The id of the model containing the variable", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model, @Parameter(description="The id of the area containing the variable", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="areaId") Area area, @Parameter(description="The id of the sub-area containing the variable", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="subAreaId") SubArea subArea, @Parameter(description="The id of the variable to be amended", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="variableId") Variable existingVariable, @RequestBody @Valid VariableData variableData, Principal principal) {
        if (!ModelChecker.inSameModel(model, area, subArea, existingVariable)) {
            return ResponseEntity.badRequest().build();
        }
        if (ModelChecker.isProtectedName(variableData.variableName())) {
            throw new ResourceException(HttpStatus.BAD_REQUEST, variableData.variableName() + " is a protected name, please change the name of the variable");
        }
        Variable oldVariable = new Variable(existingVariable);
        existingVariable.updateFromVariableData(variableData, area, subArea);
        Event<Variable> variableEvent = Event.updated(this, oldVariable, existingVariable, principal, Variable.class, model);
        this.events.publishCustomEvent(variableEvent);
        this.events.processEvents(principal);
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Delete a variable", description="Use this entrypoint to delete a variable to the model", responses={@ApiResponse(responseCode="200", description="Successfull operation"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @DeleteMapping(value={"/api/model/{modelId}/area/{areaId}/subarea/{subAreaId}/variable/{variableId}"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<String> deleteVariable(@Parameter(description="The id of the model containing the variable", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model, @Parameter(description="The id of the area containing the variable", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="areaId") Area area, @Parameter(description="The id of the sub-area containing the variable", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="subAreaId") SubArea subArea, @PathVariable(value="variableId") Variable existingVariable, Principal principal) {
        if (!ModelChecker.inSameModel(model, area, subArea, existingVariable)) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
        }
        if (this.usedInSensitivity(model, existingVariable)) {
            return ResponseEntity.badRequest().body((Object)"Cannot delete a variable used in a Sensitivity, please edit Sensitivity first");
        }
        if (this.usedInGraphs(model, existingVariable)) {
            return ResponseEntity.badRequest().body((Object)"Cannot delete a variable used in a Graph, please edit Graphs first");
        }
        if (this.usedInOtherCalculations(existingVariable)) {
            return ResponseEntity.badRequest().body((Object)"Cannot delete a variable used in another variables calculation");
        }
        if (model.getKeyParam() != null) {
            model.getKeyParam().deleteVariableFromKeyParam(existingVariable.getId());
        }
        existingVariable.getVariableDependencies().clear();
        model.getVariables().remove(existingVariable);
        Event<Variable> event = Event.deleted(this, existingVariable, principal, Variable.class, model);
        this.events.publishCustomEvent(event);
        this.events.processEvents(principal);
        return ResponseEntity.ok().build();
    }

    private void updateVariableValueWithEvent(Model model, VariableValue variableValue, Variable variable, VariableValueData variableValueData, Principal principal) {
        VariableValue variableValueBefore = new VariableValue(variableValue.asData(), variable);
        variableValue.setValue(variableValueData.value());
        variableValue.setEditor(principal.getName());
        if (variableValue.getSourceFile() == null || variableValue.getSourceFile().isEmpty()) {
            variableValue.setSourceFile("Manually registered");
        }
        if (variable.isConstant()) {
            variableValue.setPeriod(null);
        }
        if (!variable.isModelledAtSegment()) {
            variableValue.setAttachedSegment(null);
        }
        Event<VariableValue> event = Event.updated(this, variableValueBefore, variableValue, principal, VariableValue.class, model);
        this.events.publishCustomEvent(event);
    }

    private VariableValue createAndSaveVariableValueWithEvent(Model model, Variable variable, VariableValueData variableValueData, Principal principal) {
        log.debug("Detecting duplicates");
        try {
            if (variable.getVariableValues().stream().anyMatch(variableValue -> {
                boolean isSamePeriod = Objects.equals(variableValue.getPeriod(), variableValueData.period());
                boolean isSameScenario = Objects.equals(variableValue.getScenarioNumber(), variableValueData.scenarioNumber());
                boolean isSameNullSegment = variableValue.getAttachedSegment() == null && (variableValueData.attachedSegmentId() == null || variableValueData.attachedSegmentId() <= 0L);
                boolean isSameNonNullSegment = variableValue.getAttachedSegment() != null && variableValueData.attachedSegmentId() != null && variableValue.getAttachedSegment().getId() == variableValueData.attachedSegmentId().longValue();
                return isSamePeriod && isSameScenario && (isSameNullSegment || isSameNonNullSegment);
            })) {
                log.info("Duplicate variable data is detected" + variableValueData.value());
                throw new ResourceException(HttpStatus.BAD_REQUEST, "Duplicate variable value data is detected");
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new ResourceException(HttpStatus.BAD_REQUEST, "Duplicate variable value data is detected");
        }
        log.debug("Checking segment");
        if (variable.isModelledAtSegment() && variableValueData.attachedSegmentId() == null) {
            log.info("Received variable value for a variable modelled at segment but no segment was attached " + variableValueData.value());
            throw new ResourceException(HttpStatus.BAD_REQUEST, "Trying to set a value on a variable defined at segment");
        }
        if (variableValueData.attachedSegmentId() != null && variableValueData.attachedSegmentId() > 0L && model.getSegments().stream().noneMatch(s -> s.getId() == variableValueData.attachedSegmentId().longValue())) {
            log.info("AttachedSegmentId was not found in model segments" + variableValueData.attachedSegmentId());
            throw new ResourceException(HttpStatus.BAD_REQUEST, "Trying to set a value on a variable defined at segment");
        }
        log.debug("Checking variable");
        if (variableValueData.attachedVariableId() != null && (variableValueData.attachedVariableId().equals(-1L) || !variableValueData.attachedVariableId().equals(variable.getId()))) {
            log.info("Invalid attached variableID");
            throw new ResourceException(HttpStatus.BAD_REQUEST, "VariableValueData had no valid variable id ");
        }
        log.debug("Converting variableValueData to variableValue");
        VariableValue variableValue2 = new VariableValue(variableValueData, variable);
        variableValue2.setEditor(principal.getName());
        if (variableValue2.getSourceFile() == null || variableValue2.getSourceFile().isEmpty()) {
            variableValue2.setSourceFile("Manually registered");
        }
        if (variable.isConstant()) {
            variableValue2.setPeriod(null);
        }
        log.debug("Checking modelled at segment");
        if (!variable.isModelledAtSegment()) {
            variableValue2.setAttachedSegment(null);
        } else if (variableValueData.attachedSegmentId() != null && variableValueData.attachedSegmentId() > 0L) {
            model.getSegments().stream().filter(s -> Long.valueOf(s.getId()).equals(variableValueData.attachedSegmentId())).forEach(variableValue2::setAttachedSegment);
        }
        try {
            variable.getVariableValues().add(variableValue2);
            variableValue2 = this.entityService.safeCreate(VariableValue.class, variableValue2, variable).orElseThrow();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        Event<VariableValue> event = Event.created(this, variableValue2, principal, VariableValue.class, model);
        this.events.publishCustomEvent(event);
        return variableValue2;
    }

    @Operation(summary="Add a single value to a variable", description="Use this entrypoint to add a single value to a variable. The value is valid for a defined scenario and period", responses={@ApiResponse(responseCode="201", description="The id of the created variable value"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @PostMapping(value={"/api/model/{modelId}/variable/{variableId}/value"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<Long> addVariableValue(@Parameter(description="The id of the model containing the variable", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model, @Parameter(description="The id of the variable to be amended", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="variableId") Variable variable, @RequestBody @Valid VariableValueData variableValueData, Principal principal) {
        if (!ModelChecker.inSameModel(model, variable)) {
            return ResponseEntity.badRequest().build();
        }
        VariableValue variableValue = this.createAndSaveVariableValueWithEvent(model, variable, variableValueData, principal);
        if (variableValue.getId() > 0L) {
            this.events.processEvents(principal);
            return new ResponseEntity((Object)variableValue.getId(), (HttpStatusCode)HttpStatus.CREATED);
        }
        return ResponseEntity.badRequest().build();
    }

    @Operation(summary="Import several values at the same time", description="Use this entrypoint to add several values to several variables.", responses={@ApiResponse(responseCode="201", description="The ids of the created variable values"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @PostMapping(value={"/api/model/{modelId}/variablevalues/import"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<List<Long>> importVariableValues(@Parameter(description="The id of the model containing the variable", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model, @RequestBody @Valid ImportVariableValueData importVariableValueData, Principal principal) {
        log.info("Creating a new model import from filename: " + importVariableValueData.sourceFile());
        return this.addOrUpdateVariableValues(model, importVariableValueData.variableValueData(), principal);
    }

    @Operation(summary="Create or update several values at the same time", description="Use this entrypoint to create or update several values to several variables.", responses={@ApiResponse(responseCode="201", description="The ids of the created variable values"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @PostMapping(value={"/api/model/{modelId}/variablevalues"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<List<Long>> addOrUpdateVariableValues(@Parameter(description="The id of the model containing the variable", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model, @RequestBody @Valid List<VariableValueData> variableValueDataList, Principal principal) {
        ArrayList ids = new ArrayList();
        for (VariableValueData variableValueData : variableValueDataList) {
            model.getVariableWithID(variableValueData.attachedVariableId()).ifPresent(variable -> {
                if (variableValueData.id() == -1L) {
                    ids.add(this.createAndSaveVariableValueWithEvent(model, (Variable)variable, variableValueData, principal).getId());
                } else {
                    variable.getVariableValues().stream().filter(vv -> Objects.equals(vv.getId(), variableValueData.id())).findFirst().ifPresent(variableValueFromDb -> {
                        this.updateVariableValueWithEvent(model, (VariableValue)variableValueFromDb, (Variable)variable, variableValueData, principal);
                        ids.add(variableValueFromDb.getId());
                    });
                }
            });
        }
        this.events.processEvents(principal);
        return ResponseEntity.ok(ids);
    }

    @Operation(summary="Update a single variable value", description="Use this entrypoint to update a single variable value", responses={@ApiResponse(responseCode="200", description="Successfull operation"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @PutMapping(value={"/api/model/{modelId}/variable/{variableId}/value/{variableValueId}"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<String> updateVariableValue(@Parameter(description="The id of the model containing the variable", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model, @Parameter(description="The id of the variable to be amended", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="variableId") Variable variable, @Parameter(description="The id of the value to be amended", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="variableValueId") VariableValue variableValue, @RequestBody @Valid VariableValueData variableValueData, Principal principal) {
        if (!ModelChecker.inSameModel(model, variable, variableValue)) {
            return ResponseEntity.badRequest().build();
        }
        this.updateVariableValueWithEvent(model, variableValue, variable, variableValueData, principal);
        this.events.processEvents(principal);
        return ResponseEntity.ok((Object)"");
    }

    @Operation(summary="Delete a single variable value", description="Use this entrypoint to delete a single variable value", responses={@ApiResponse(responseCode="200", description="Successfull operation"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @DeleteMapping(value={"/api/model/{modelId}/variable/{variableId}/value/{variableValueId}"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<String> deleteCellValue(@Parameter(description="The id of the model containing the variable", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model, @Parameter(description="The id of the variable to be amended", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="variableId") Variable variable, @Parameter(description="The id of the value to be amended", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="variableValueId") VariableValue variableValue, Principal principal) {
        if (!ModelChecker.inSameModel(model, variable, variableValue)) {
            return ResponseEntity.badRequest().build();
        }
        variable.getVariableValues().removeIf(variableValue1 -> variableValue1.getId() == variableValue.getId());
        Event<VariableValue> event = Event.deleted(this, variableValue, principal, VariableValue.class, model);
        this.events.publishCustomEvent(event);
        this.events.processEvents(principal);
        return ResponseEntity.ok().build();
    }

    private boolean usedInOtherCalculations(Variable existingVariable) {
        return existingVariable.getAttachedModel().getVariables().stream().filter(modelVariable -> !Objects.equals(existingVariable, modelVariable)).anyMatch(variable -> variable.getVariableDependencies().contains(existingVariable));
    }

    private boolean usedInGraphs(Model model, Variable existingVariable) {
        return model.getGraphs().stream().anyMatch(modelGraph -> Arrays.asList(modelGraph.getGraphVariable1Id(), modelGraph.getGraphVariable2Id(), modelGraph.getGraphVariable3Id()).contains(existingVariable.getId()));
    }

    private boolean usedInSensitivity(Model model, Variable existingVariable) {
        return model.getSensitivities().stream().anyMatch(sensitivity -> sensitivity.getSensitivityVariable1Id().equals(existingVariable.getId()) || sensitivity.getSensitivityVariable2Id().equals(existingVariable.getId()));
    }
}

