/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.openai;

import app.valuationcontrol.webservice.helpers.CalculationData;
import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.variable.Variable;
import app.valuationcontrol.webservice.openai.OpenAIHelperFunctions;
import app.valuationcontrol.webservice.openai.OpenAiServiceImplementation;
import app.valuationcontrol.webservice.xlhandler.SCENARIO;
import app.valuationcontrol.webservice.xlhandler.XLHandleManager;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.completion.chat.ChatMessageRole;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class OpenAiController {
    private static final Logger log = LogManager.getLogger(OpenAiController.class);
    private final XLHandleManager xlHandleManager;
    private final OpenAiServiceImplementation openAiServiceImplementation;

    @Autowired
    public OpenAiController(XLHandleManager xlHandleManager, OpenAiServiceImplementation openAiServiceImplementation) {
        this.xlHandleManager = xlHandleManager;
        this.openAiServiceImplementation = openAiServiceImplementation;
    }

    @Operation(summary="Review the model using OpenAI", description="Use this entrypoint to review the model's variable using OPENAI", responses={@ApiResponse(responseCode="200", description="Successfull operation"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @GetMapping(value={"/api/model/{modelId}/variable/{variableId}/aiprompt"}, produces={"application/json"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'READER')")
    public ResponseEntity<JsonNode> prompt(@Parameter(description="The id of the model to be amended or deleted", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model, @Parameter(description="The id of the variable to be amended", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="variableId") Variable variable, @Schema(type="String") String prompt) {
        CalculationData calculationData = this.xlHandleManager.getXLInstanceForModel(model).getContent(SCENARIO.BASE);
        ObjectNode returnObject = OpenAIHelperFunctions.prepareSingleVariable(calculationData, model, variable, true);
        ChatMessage systemMessage = new ChatMessage(ChatMessageRole.SYSTEM.value(), prompt);
        ChatMessage firstMsg = new ChatMessage(ChatMessageRole.USER.value(), returnObject.toPrettyString());
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        messages.add(systemMessage);
        messages.add(firstMsg);
        return ResponseEntity.ok((Object)OpenAIHelperFunctions.doRequest(this.openAiServiceImplementation, messages, null, null));
    }

    @Operation(summary="Review the model using OpenAI", description="Use this entrypoint to review the model's variable using OPENAI", responses={@ApiResponse(responseCode="200", description="Successfull operation"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @GetMapping(value={"/api/model/{modelId}/variable/{variableId}/review"}, produces={"application/json"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'READER')")
    public ResponseEntity<JsonNode> reviewVariable(@Parameter(description="The id of the model to be amended or deleted", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model, @Parameter(description="The id of the variable to be amended", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="variableId") Variable variable) {
        CalculationData calculationData = this.xlHandleManager.getXLInstanceForModel(model).getContent(SCENARIO.BASE);
        ObjectNode returnObject = OpenAIHelperFunctions.prepareSingleVariable(calculationData, model, variable, true);
        String question = "You are a financial analyst reviewing the soundness of a financial model provided in JSON. Comment on the consistency of the forecast using a mathematical approach. Forecasted values are in the field 'values' or 'value' if the variable is a constant";
        ChatMessage systemMessage = new ChatMessage(ChatMessageRole.SYSTEM.value(), question);
        ChatMessage firstMsg = new ChatMessage(ChatMessageRole.USER.value(), returnObject.toPrettyString());
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        messages.add(systemMessage);
        messages.add(firstMsg);
        return ResponseEntity.ok((Object)OpenAIHelperFunctions.doRequest(this.openAiServiceImplementation, messages, this.openAiServiceImplementation.getReviewFunction(), "get_review"));
    }
}

