/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.securityhelpers;

import app.valuationcontrol.webservice.securityhelpers.MyUserPrincipal;
import app.valuationcontrol.webservice.user.User;
import app.valuationcontrol.webservice.user.UserRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"mockuserservice"}, havingValue="false", matchIfMissing=true)
public class MyUserDetailsService
implements UserDetailsService {
    protected final UserRepository userRepository;

    @Autowired
    public MyUserDetailsService(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public UserDetails loadUserByUsername(String username) {
        User user = this.userRepository.findByEmail(username);
        if (user == null) {
            user = new User();
            user.setEmail(username);
        }
        return new MyUserPrincipal(user);
    }
}

