/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.securityhelpers;

import app.valuationcontrol.webservice.securityhelpers.AllowedOrigins;
import app.valuationcontrol.webservice.securityhelpers.JwtAuthenticationConverter;
import app.valuationcontrol.webservice.securityhelpers.stompInterceptors.TopicSubscriptionInterceptor;
import app.valuationcontrol.webservice.securityhelpers.stompInterceptors.VerifyConnectInterceptor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;

@Component
@Configuration
@EnableWebSocketMessageBroker
@Order(value=-2147483549)
public class WebSocketConfiguration
implements WebSocketMessageBrokerConfigurer {
    private static final Logger log = LogManager.getLogger(WebSocketConfiguration.class);
    private static final String MESSAGE_PREFIX = "/topic";
    private final JwtDecoder jwtDecoder;
    private final JwtAuthenticationConverter jwtAuthenticationConverter;
    private final AllowedOrigins allowedOrigins;

    @Autowired
    public WebSocketConfiguration(JwtDecoder jwtDecoder, JwtAuthenticationConverter jwtAuthenticationConverter, AllowedOrigins allowedOrigins) {
        this.jwtDecoder = jwtDecoder;
        this.jwtAuthenticationConverter = jwtAuthenticationConverter;
        this.allowedOrigins = allowedOrigins;
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/events"}).setAllowedOrigins(this.allowedOrigins.getAllowedOrigins().toArray(new String[0])).withSockJS();
    }

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        registry.enableSimpleBroker(new String[]{MESSAGE_PREFIX});
    }

    public void configureClientInboundChannel(ChannelRegistration registration) {
        registration.interceptors(new ChannelInterceptor[]{new VerifyConnectInterceptor(this.jwtDecoder, this.jwtAuthenticationConverter), new TopicSubscriptionInterceptor()});
    }
}

