/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.user;

import app.valuationcontrol.webservice.EntityService;
import app.valuationcontrol.webservice.helpers.EntityDTOConverter;
import app.valuationcontrol.webservice.helpers.ModelProvider;
import app.valuationcontrol.webservice.helpers.exceptions.ResourceException;
import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.user.Email;
import app.valuationcontrol.webservice.user.User;
import app.valuationcontrol.webservice.user.UserAccessData;
import app.valuationcontrol.webservice.user.UserData;
import app.valuationcontrol.webservice.user.UserRepository;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserController {
    private final UserRepository userRepository;
    private final EntityService entityService;

    public UserController(UserRepository userRepository, EntityService entityService) {
        this.userRepository = userRepository;
        this.entityService = entityService;
    }

    @GetMapping(value={"/api/user/models"})
    @ResponseBody
    public ResponseEntity<UserData> getModels(Principal principal) {
        ResponseEntity myResponseEntity;
        if (principal != null) {
            User user = this.userRepository.findByEmail(principal.getName());
            if (user != null) {
                myResponseEntity = ResponseEntity.ok((Object)((UserData)EntityDTOConverter.asData(user)));
            } else {
                User user2 = new User();
                user2.setEmail(principal.getName());
                myResponseEntity = ResponseEntity.ok((Object)((UserData)EntityDTOConverter.asData(user2)));
            }
        } else {
            throw new ResourceException(HttpStatus.BAD_REQUEST, "You do not have access to any models yet");
        }
        return myResponseEntity;
    }

    @Operation(summary="List all users having access to the model", responses={@ApiResponse(responseCode="200", description="Successfull operation"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="401", description="Unauthorized access"), @ApiResponse(responseCode="500", description="Server error")})
    @GetMapping(value={"/api/model/{modelId}/users"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'READER')")
    @ResponseBody
    public ResponseEntity<List<UserAccessData>> getUserModelAccess(@Parameter(description="The id of the model to be amended or deleted", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model, Principal principal) {
        if (principal == null) {
            throw new ResourceException(HttpStatus.BAD_REQUEST, "You do not have access to any models yet");
        }
        ArrayList<User> users = this.userRepository.findByModel(model);
        return ResponseEntity.ok(users.stream().map(user -> new UserAccessData(user.getId(), user.getEmail(), User.MODEL_ROLE.valueOf(user.getModelRoles().get(model)))).toList());
    }

    @PutMapping(value={"/api/model/{modelId}/role/{role}"}, consumes={"application/json"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'ADMIN')")
    public ResponseEntity<Long> addUserToModel(@Parameter(description="The id of the model to be amended or deleted", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model, @PathVariable(value="role") User.MODEL_ROLE role, @Valid @RequestBody Email email, Principal principal) {
        User existingUser = this.userRepository.findByEmail(email.value());
        if (existingUser == null) {
            User newUser = new User();
            newUser.setEmail(email.value());
            existingUser = this.entityService.create(User.class, newUser);
        }
        existingUser.addModel(model, role);
        this.entityService.safeUpdate(User.class, existingUser, existingUser, new ModelProvider[0]);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @DeleteMapping(value={"/api/model/{modelId}/user/{userId}"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'ADMIN')")
    public ResponseEntity<Void> removeUserModelRole(@Parameter(description="The id of the model to be amended or deleted", in=ParameterIn.PATH, required=true) @Schema(type="Integer", minimum="1") @PathVariable(value="modelId") Model model, @Parameter(description="The id of the user to be deleted") @PathVariable Long userId, Principal principal) {
        User existingUser = (User)this.userRepository.getReferenceById(userId);
        User principalUser = this.userRepository.findByEmail(principal.getName());
        if (existingUser == null) {
            return ResponseEntity.notFound().build();
        }
        if (existingUser.equals(principalUser)) {
            throw new ResourceException(HttpStatus.BAD_REQUEST, "You cannot delete yourself from this model, please ask another administrator");
        }
        existingUser.getModelRoles().remove(model);
        this.entityService.safeUpdate(User.class, existingUser, existingUser, new ModelProvider[0]);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }
}

