/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.xlhandler;

import app.valuationcontrol.webservice.helpers.DataPeriod;
import app.valuationcontrol.webservice.model.variable.Variable;
import app.valuationcontrol.webservice.model.variablevalue.VariableValue;
import app.valuationcontrol.webservice.xlhandler.GenericSheet;

public class CellValueHelper {
    public static final int AZ_COUNTER = 26;

    public static GenericSheet.CellValue cellValueOf(VariableValue variableValue) {
        Variable variable = variableValue.getAttachedVariable();
        int columnIndex = variable.columnOfSegmentAndPeriod(variableValue.getAttachedSegment(), variableValue.getPeriod());
        return new GenericSheet.CellValue(variableValue.getValue().floatValue(), columnIndex, variable.getRow());
    }

    public static String generateAddress(Variable variable, DataPeriod dataPeriod) {
        int columnToAssess = variable.isSingleOrConstantValue() ? variable.getAttachedModel().getConstantColumn() + dataPeriod.getSegmentOffsetAsInteger() : variable.getPrimaryColumn() + dataPeriod.getTotalOffsetAsInteger();
        return CellValueHelper.generateAddress(variable, columnToAssess);
    }

    public static String generateAddress(Variable variable, int columnToAssess) {
        String prefix = "";
        int rowToAssess = variable.getRow() + 1;
        int multiplier = columnToAssess / 26;
        int rest = columnToAssess % 26;
        if (multiplier >= 1) {
            prefix = Character.toString((char)(65 + multiplier - 1));
        }
        String column = prefix + (char)(65 + rest);
        String returnString = variable.isSingleOrConstantValue() ? "$" + column + "$" + rowToAssess : column + rowToAssess;
        return returnString;
    }
}

