/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.xlhandler;

import app.valuationcontrol.webservice.helpers.poiudf.DateDif;
import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.xlhandler.CalcDocumentFactoryImpl;
import app.valuationcontrol.webservice.xlhandler.ModelChangeNotifier;
import app.valuationcontrol.webservice.xlhandler.ScenarioDataProvider;
import app.valuationcontrol.webservice.xlhandler.XLInstance;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.formula.WorkbookEvaluator;
import org.apache.poi.ss.formula.functions.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class XLHandleManager {
    private static final Logger log = LogManager.getLogger(XLHandleManager.class);
    private final Map<Long, XLInstance> xlInstanceByModelId = new ConcurrentHashMap<Long, XLInstance>();
    private final ModelChangeNotifier modelChangeNotifier;
    private final Duration inactivityThreshold;
    private final CalcDocumentFactoryImpl calcDocumentFactory;
    private boolean isSystemShuttingDown;

    @Autowired
    public XLHandleManager(ModelChangeNotifier modelChangeNotifier, @Value(value="${xlinstance.unused.threshold}") int secondsOfInactivityAllowed, CalcDocumentFactoryImpl calcDocumentFactory) {
        this.modelChangeNotifier = modelChangeNotifier;
        this.inactivityThreshold = Duration.ofSeconds(secondsOfInactivityAllowed);
        this.calcDocumentFactory = calcDocumentFactory;
        log.info("Registering additional excel function");
        WorkbookEvaluator.registerFunction((String)"DATEDIF", (Function)new DateDif());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.isSystemShuttingDown = true;
        }));
    }

    @Scheduled(fixedRate=30L, timeUnit=TimeUnit.SECONDS)
    private synchronized void closeUnusedDocuments() {
        this.xlInstanceByModelId.forEach((modelId, xlInstance) -> {
            if (xlInstance.isUnusedFor(this.inactivityThreshold) && this.modelChangeNotifier.fetchScenariosFromUserRegistry((Long)modelId).isEmpty()) {
                log.debug("Closing model {}", modelId);
                xlInstance.sleep();
                this.xlInstanceByModelId.remove(modelId);
            }
        });
    }

    protected XLInstance createModelInstance(Model model) {
        return new XLInstance(model, this.calcDocumentFactory.getDocument(), this.modelChangeNotifier);
    }

    public synchronized ScenarioDataProvider getXLInstanceForModel(Model model) {
        if (this.isSystemShuttingDown) {
            return null;
        }
        XLInstance xlInstance = this.xlInstanceByModelId.computeIfAbsent(model.getId(), l -> this.createModelInstance(model));
        xlInstance.setAttachedModel(model);
        return xlInstance;
    }
}

