package app.valuationcontrol.webservice.helpers;

import java.util.Arrays;
import org.apache.poi.ss.formula.WorkbookEvaluator;

public abstract class ModelChecker {
  private ModelChecker() {}

  public static boolean inSameModel(ModelProvider... modelProviders) {
    if (modelProviders.length != 0) {
      return Arrays.stream(modelProviders).map(ModelProvider::getModelId).distinct().count() == 1;
    }
    return true;
  }

  public static boolean isProtectedName(String variableName) {
    return WorkbookEvaluator.getNotSupportedFunctionNames().stream()
            .anyMatch(fn -> fn.equalsIgnoreCase(variableName))
        || WorkbookEvaluator.getSupportedFunctionNames().stream()
            .anyMatch(fn -> fn.equalsIgnoreCase(variableName));
  }
}
