package app.valuationcontrol.webservice.model;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraints.NotNull;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BracketsValidatorImpl implements ConstraintValidator<EvenBrackets, String> {

  private static final Pattern LEFT_BRACKET = Pattern.compile("\\[");
  private static final Pattern RIGHT_BRACKET = Pattern.compile("\\]");

  @Override
  public boolean isValid(String value, ConstraintValidatorContext context) {
    if (value == null) {
      return false;
    }

    return count(value, LEFT_BRACKET) == count(value, RIGHT_BRACKET);
  }

  static int count(@NotNull String value, Pattern pattern) {
    int occurrences = 0;

    final Matcher matcher = pattern.matcher(value);

    while (matcher.find()) {
      occurrences++;
    }

    return occurrences;
  }
}
