package app.valuationcontrol.webservice.model.events.listeners.logger;

import static java.lang.String.format;

import app.valuationcontrol.webservice.model.area.Area;
import app.valuationcontrol.webservice.model.events.Event;
import app.valuationcontrol.webservice.model.events.listeners.AuditLog;
import app.valuationcontrol.webservice.model.logentry.LogEntryRepository;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class AreaLogger {

  private static final String REMOVED_AREA = "Removed zone %s";
  private static final String ADDED_AREA = "Added zone %s";
  private static final String UPDATED_AREA = "Updated zone %s";

  private final LogEntryRepository logEntryRepository;

  public AreaLogger(LogEntryRepository logEntryRepository) {
    this.logEntryRepository = logEntryRepository;
  }

  @EventListener
  public void onEvent(Event<Area> event) {

    switch (event.getType()) {
      case CREATED -> AuditLog.log(
          this.logEntryRepository,
          event.getNewVersion().getAttachedModel(),
          format(ADDED_AREA, event.getNewVersion().getAreaName()),
          event.getPrincipal());
      case DELETED -> AuditLog.log(
          this.logEntryRepository,
          event.getOldVersion().getAttachedModel(),
          format(REMOVED_AREA, event.getOldVersion().getAreaName()),
          event.getPrincipal());
      case UPDATED, METADATA_UPDATE -> AuditLog.log(
          this.logEntryRepository,
          event.getNewVersion().getAttachedModel(),
          format(UPDATED_AREA, event.getNewVersion().getAreaName()),
          event.getPrincipal());
    }
  }
}
